/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.AppUI;
import MainMenu.LoadSavedFile;
import MainMenu.Logging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class RangeSelectionFrame
extends JFrame {
    private String startDateTime = "not set";
    private String endDateTime = "not set";
    private SimpleDateFormat originalFormat = new SimpleDateFormat("MM,dd,yy,HH,mm");
    private boolean comboBoxesLoaded = false;
    private Map<String, String> addressIndex = new HashMap<String, String>();
    private JButton btnSave;
    private JButton btnUseAll;
    private JComboBox<String> cboEndTime;
    private JComboBox<String> cboStartTime;
    private JCheckBox chkIncludeFirstFourHours;
    private JLabel lblEnd;
    private JLabel lblEndText;
    private JLabel lblStart;
    private JLabel lblStartText;
    private JLabel lblTotalHours;
    private JLabel lblTotalHoursText;

    public RangeSelectionFrame() {
        this.initComponents();
        this.chkIncludeFirstFourHours.setSelected(LoadSavedFile.rangeAverageFirstFourHours);
        this.PopulateComboBoxes();
        this.RefreshStartEndDateLabels();
    }

    private void initComponents() {
        this.lblStart = new JLabel();
        this.lblEnd = new JLabel();
        this.lblTotalHours = new JLabel();
        this.cboStartTime = new JComboBox();
        this.cboEndTime = new JComboBox();
        this.btnUseAll = new JButton();
        this.btnSave = new JButton();
        this.lblStartText = new JLabel();
        this.lblEndText = new JLabel();
        this.lblTotalHoursText = new JLabel();
        this.chkIncludeFirstFourHours = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.lblStart.setFont(new Font("Calibri", 0, 12));
        this.lblStart.setText("Start:");
        this.lblEnd.setFont(new Font("Calibri", 0, 12));
        this.lblEnd.setText("End:");
        this.lblTotalHours.setFont(new Font("Calibri", 0, 12));
        this.lblTotalHours.setText("Total Hours:");
        this.cboStartTime.setFont(new Font("Calibri", 0, 12));
        this.cboStartTime.setToolTipText("Select start time of the test.");
        this.cboStartTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RangeSelectionFrame.this.cboStartTimeActionPerformed(evt);
            }
        });
        this.cboEndTime.setFont(new Font("Calibri", 0, 12));
        this.cboEndTime.setToolTipText("Select end time of the test.");
        this.cboEndTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RangeSelectionFrame.this.cboEndTimeActionPerformed(evt);
            }
        });
        this.btnUseAll.setFont(new Font("Calibri", 0, 12));
        this.btnUseAll.setText("Use All");
        this.btnUseAll.setToolTipText("Undo changes you have made, and use all of the test.");
        this.btnUseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RangeSelectionFrame.this.btnUseAllActionPerformed(evt);
            }
        });
        this.btnSave.setFont(new Font("Calibri", 0, 12));
        this.btnSave.setText("Save");
        this.btnSave.setToolTipText("Close window and redraw graph with your selection.");
        this.btnSave.setPreferredSize(new Dimension(73, 25));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RangeSelectionFrame.this.btnSaveActionPerformed(evt);
            }
        });
        this.lblStartText.setFont(new Font("Calibri", 0, 12));
        this.lblEndText.setFont(new Font("Calibri", 0, 12));
        this.lblTotalHoursText.setFont(new Font("Calibri", 0, 14));
        this.chkIncludeFirstFourHours.setText("Average First Four Hours");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboStartTime, 0, -1, Short.MAX_VALUE).addComponent(this.cboEndTime, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblStart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblStartText)).addGroup(layout.createSequentialGroup().addComponent(this.lblEnd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEndText)).addGroup(layout.createSequentialGroup().addComponent(this.lblTotalHours).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblTotalHoursText)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.btnUseAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSave, -2, 70, -2)).addComponent(this.chkIncludeFirstFourHours)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblStart).addComponent(this.lblStartText)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblEnd).addComponent(this.lblEndText)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTotalHours).addComponent(this.lblTotalHoursText)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkIncludeFirstFourHours).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cboStartTime, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboEndTime, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnUseAll).addComponent(this.btnSave, -2, 21, -2)).addContainerGap()));
        this.pack();
    }

    private void btnUseAllActionPerformed(ActionEvent evt) {
        this.addressIndex.clear();
        LoadSavedFile.dataRangePresent = false;
        this.chkIncludeFirstFourHours.setSelected(false);
        try {
            this.cboStartTime.removeAllItems();
            this.cboEndTime.removeAllItems();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.PopulateComboBoxes();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        LoadSavedFile.userRangeStartAddress = this.addressIndex.get(this.cboStartTime.getSelectedItem());
        LoadSavedFile.userRangeEndAddress = this.addressIndex.get(this.cboEndTime.getSelectedItem());
        LoadSavedFile.rangeBuffer.clear();
        LoadSavedFile.LoadRangeBuffer();
        this.dispose();
        LoadSavedFile.rangeAverageFirstFourHours = this.chkIncludeFirstFourHours.isSelected();
        LoadSavedFile.dataRangePresent = true;
        LoadSavedFile.ProcessBuffer(LoadSavedFile.rangeBuffer);
    }

    private void cboStartTimeActionPerformed(ActionEvent evt) {
        if (this.comboBoxesLoaded) {
            this.SetStartEndDateStrings("start", this.cboStartTime.getSelectedItem().toString());
            this.RefreshStartEndDateLabels();
        }
    }

    private void cboEndTimeActionPerformed(ActionEvent evt) {
        if (this.comboBoxesLoaded) {
            this.SetStartEndDateStrings("end", this.cboEndTime.getSelectedItem().toString());
            this.RefreshStartEndDateLabels();
        }
    }

    public static void main(String[] args) {
    }

    private void PopulateComboBoxes() {
        if (!LoadSavedFile.dataRangePresent) {
            this.LoadDateStringsFromDataSet(LoadSavedFile.fileBuffer);
        } else {
            this.LoadDateStringsFromDataSet(LoadSavedFile.rangeBuffer);
        }
        this.comboBoxesLoaded = true;
    }

    private void LoadDateStringsFromDataSet(LinkedList<String> dataSet) {
        String currentLine = null;
        String[] currentLine_parsed = null;
        int hourCounter = 6;
        for (int i = 0; i < dataSet.size(); ++i) {
            currentLine = dataSet.get(i);
            if (!currentLine.contains("=DB") || currentLine.contains("H") || currentLine.contains("W") || currentLine.contains("Z")) continue;
            currentLine_parsed = currentLine.split(",");
            if (currentLine.contains("S")) {
                this.SetStartEndDateStrings("start", currentLine_parsed[4], currentLine_parsed[5], currentLine_parsed[3], currentLine_parsed[6], currentLine_parsed[7]);
                this.addressIndex.put(this.GetDateStringFormatted(currentLine_parsed), currentLine_parsed[1]);
            }
            if (currentLine.contains("E")) {
                this.SetStartEndDateStrings("end", currentLine_parsed[4], currentLine_parsed[5], currentLine_parsed[3], currentLine_parsed[6], currentLine_parsed[7]);
                this.addressIndex.put(this.GetDateStringFormatted(currentLine_parsed), currentLine_parsed[1]);
            }
            if (hourCounter == 6) {
                this.cboStartTime.addItem(this.GetDateStringFormatted(currentLine_parsed));
                this.cboStartTime.setSelectedIndex(0);
                this.cboEndTime.addItem(this.GetDateStringFormatted(currentLine_parsed));
                this.cboEndTime.setSelectedIndex(this.cboEndTime.getItemCount() - 1);
                this.addressIndex.put(this.GetDateStringFormatted(currentLine_parsed), currentLine_parsed[1]);
                hourCounter = 0;
            }
            ++hourCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String GetDateStringFormatted(String[] reconString) {
        String strFormattedDate = "not set";
        try {
            Date tempDate = this.originalFormat.parse(reconString[4] + "," + reconString[5] + "," + reconString[3] + "," + reconString[6] + "," + reconString[7]);
            strFormattedDate = AppUI.niceDateFormat.format(tempDate);
            return strFormattedDate;
        }
        catch (Exception anyEx) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
        finally {
            return strFormattedDate;
        }
    }

    private void SetStartEndDateStrings(String startOrEnd, String month, String day, String year, String hour, String minute) {
        switch (startOrEnd) {
            case "start": {
                this.startDateTime = month + "," + day + "," + year + "," + hour + "," + minute;
                break;
            }
            case "end": {
                this.endDateTime = month + "," + day + "," + year + "," + hour + "," + minute;
                break;
            }
        }
    }

    private void SetStartEndDateStrings(String startOrEnd, String comboBoxNiceDateFormatString) {
        try {
            Date stringDate = AppUI.niceDateFormat.parse(comboBoxNiceDateFormatString);
            switch (startOrEnd) {
                case "start": {
                    this.startDateTime = this.originalFormat.format(stringDate);
                    break;
                }
                case "end": {
                    this.endDateTime = this.originalFormat.format(stringDate);
                    break;
                }
            }
        }
        catch (Exception anyEx) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    private void RefreshStartEndDateLabels() {
        try {
            Date startDate = this.originalFormat.parse(this.startDateTime);
            Date endDate = this.originalFormat.parse(this.endDateTime);
            this.lblStartText.setText(AppUI.niceDateFormat.format(startDate));
            this.lblEndText.setText(AppUI.niceDateFormat.format(endDate));
            this.lblTotalHoursText.setText(Long.toString((endDate.getTime() - startDate.getTime()) / 3600000L));
            if (Integer.parseInt(this.lblTotalHoursText.getText().toString()) < 48) {
                this.lblTotalHoursText.setForeground(Color.RED);
            } else {
                this.lblTotalHoursText.setForeground(Color.GREEN);
            }
        }
        catch (Exception anyEx) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }
}

