/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import Config.Config;
import Config.FlagForm;
import MainMenu.AppUI;
import MainMenu.ImageSelectionPanel;
import MainMenu.InitDirs;
import MainMenu.LegacyUI;
import MainMenu.LimitLinesDocumentListener;
import MainMenu.LoadSavedFile;
import MainMenu.Logging;
import MainMenu.RangeSelectionFrame;
import MainMenu.ReconProtocol;
import MainMenu.TMProtocol;
import MainMenu.TestDetails;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class MainMenuUI
extends AppUI {
    public static AppUI appUI = null;
    DecimalFormat cfFormat = new DecimalFormat("0.000");
    public static LinkedList<String> themeNames;
    public static Map<String, String> themeFullyQualifiedClassNames;
    public static boolean flatLafThemesLoaded;
    private JButton btnBackup;
    private JButton btnRestore;

    public MainMenuUI() {
        File xlsTemplate = new File("ReconTemplate.xls");
        if (!xlsTemplate.exists()) {
            Logging.main("XLS template not present. You will not be able to create XLS files.");
        }
        this.initComponents();
        MainMenuUI.RefreshDeploymentFields();
        MainMenuUI.InitDeploymentFields();
        txtLogScroll.getDocument().addDocumentListener(new LimitLinesDocumentListener(500));
        lblReconSN.setVisible(false);
        lblFirmwareVersion.setVisible(false);
        lblDataSessions.setVisible(false);
        this.btnClearSession.setVisible(false);
        this.btnClearMemory.setVisible(false);
        this.btnAllDataDump.setVisible(false);
        this.btnDownloadSession.setVisible(false);
        this.btnOpenSavedFile.setVisible(true);
        btnGeneratePDF.setVisible(false);
        this.btnEraseReconData.setVisible(false);
        lblLoadedFile.setVisible(false);
        lblLoadedFileName.setVisible(false);
        btnMainImages.setVisible(false);
        this.btnSyncTime.setVisible(false);
        this.btnClearTamperFlag.setVisible(false);
        btnCloseFile.setVisible(false);
        this.btnExport.setVisible(false);
        this.btnTestDetails.setVisible(false);
        lblCalibrationDate.setVisible(false);
        lblCalibrationDue.setVisible(false);
        this.btnDisplaySettings.setVisible(false);
        lblVersion.setText(this.version);
        pnlStartEndDate.setVisible(false);
        if (countLimiter) {
            this.limiterLabel.setVisible(false);
        }
        this.EnableFileNaming(false);
        cboSessionSelect.setVisible(false);
        this.pnlDisplayHelp.setLayout(new BoxLayout(this.pnlDisplayHelp, 1));
        final JEditorPane contentPane = new JEditorPane();
        JScrollPane contentScroller = new JScrollPane(contentPane);
        contentPane.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        contentPane.setEditable(false);
        contentPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        contentPane.setPage(e.getURL());
                    }
                    catch (Exception anyEx) {
                        Logging.main(anyEx.toString());
                    }
                }
            }
        });
        try {
            URL filename = new File(InitDirs.appDir + "manual.html").toURI().toURL();
            contentPane.setPage(filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pnlDisplayHelp.add(contentScroller);
    }

    public static void InitDeploymentFields() {
        txtCustomerInfo.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtTestSiteInfo.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtLocation.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtMainDeployedBy.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtMainRetrievedBy.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtMainAnalyzedBy.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtMainWeather.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtMainMitigation.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtMainComment.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtMainProtocol.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtMainTampering.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
    }

    public static void RefreshDeploymentFields() {
        txtCustomerInfo.setText("");
        txtTestSiteInfo.setText("");
        txtLocation.setText("");
        txtMainDeployedBy.setText(strDeployedBy);
        txtMainRetrievedBy.setText(strRetrievedBy);
        txtMainAnalyzedBy.setText(strAnalyzedBy);
        txtMainWeather.setText(strWeather);
        txtMainMitigation.setText(strMitigation);
        txtMainComment.setText(strComment);
        txtMainProtocol.setText(strProtocol);
        txtMainTampering.setText(strTampering);
    }

    private void initComponents() {
        lblSystemConsole = new JLabel();
        this.btnConnect = new JButton();
        lblVersion = new JLabel();
        this.limiterLabel = new JLabel();
        lblFinalAvg = new JLabel();
        this.pnlMainDeployment = new JPanel();
        this.lblTestSiteInfo1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        txtCustomerInfo = new JTextArea();
        this.lblTestSiteInfo = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        txtTestSiteInfo = new JTextArea();
        this.lblLocation = new JLabel();
        this.lblMainWeather = new JLabel();
        this.lblMainProtocol = new JLabel();
        this.lblMainMitigation = new JLabel();
        this.lblMainTampering = new JLabel();
        this.lblMainComment = new JLabel();
        txtLocation = new JTextField();
        txtMainTampering = new JTextField();
        txtMainProtocol = new JTextField();
        txtMainWeather = new JTextField();
        txtMainMitigation = new JTextField();
        this.lblMainDeployedBy = new JLabel();
        txtMainDeployedBy = new JTextField();
        this.lblMainRetrievedBy = new JLabel();
        txtMainRetrievedBy = new JTextField();
        this.lblMainAnalyzedBy = new JLabel();
        txtMainAnalyzedBy = new JTextField();
        txtMainComment = new JTextField();
        pnlStartEndDate = new JPanel();
        this.lblStartDate = new JLabel();
        this.lblEndDateTime = new JLabel();
        this.lblTotalHours = new JLabel();
        btnRange = new JButton();
        lblStartDateTimeDynamic = new JLabel();
        lblEndDateTimeDynamic = new JLabel();
        lblTotalHoursDynamic = new JLabel();
        btnMainImages = new JButton();
        this.btnTestDetails = new JButton();
        this.pnlFileMgmt = new JPanel();
        this.btnOpenSavedFile = new JButton();
        this.btnOpenSavedFile.setAlignmentX(0.5f);
        this.btnOpenPDF = new JButton();
        this.btnOpenPDF.setAlignmentX(0.5f);
        btnGeneratePDF = new JButton();
        btnGeneratePDF.setAlignmentX(0.5f);
        btnCloseFile = new JButton();
        btnCloseFile.setAlignmentX(0.5f);
        this.btnExport = new JButton();
        this.btnExport.setAlignmentX(0.5f);
        this.btnBackup = new JButton();
        this.btnBackup.setAlignmentX(0.5f);
        this.btnRestore = new JButton();
        this.btnRestore.setAlignmentX(0.5f);
        this.pnlReconStatus = new JPanel();
        cboSessionSelect = new JComboBox();
        this.txtNewFileName = new JTextField();
        this.chkUseStreetAddressForFilename = new JCheckBox();
        lblFirmwareVersion = new JLabel();
        lblReconSN = new JLabel();
        lblCalibrationDate = new JLabel();
        lblDataSessions = new JLabel();
        lblCalibrationDue = new JLabel();
        this.btnDownloadSession = new JButton();
        this.lblStatusNoRecon = new JLabel();
        pnlGraph = new JPanel();
        lblLoadedFile = new JLabel();
        lblLoadedFileName = new JLabel();
        this.pnlReconButtons = new JPanel();
        this.btnEraseReconData = new JButton();
        this.btnEraseReconData.setAlignmentX(0.5f);
        this.btnClearSession = new JButton();
        this.btnClearSession.setAlignmentX(0.5f);
        this.btnClearMemory = new JButton();
        this.btnClearMemory.setAlignmentX(0.5f);
        this.btnAllDataDump = new JButton();
        this.btnAllDataDump.setAlignmentX(0.5f);
        this.btnClearTamperFlag = new JButton();
        this.btnClearTamperFlag.setAlignmentX(0.5f);
        this.btnSyncTime = new JButton();
        this.btnSyncTime.setAlignmentX(0.5f);
        this.btnDisplaySettings = new JButton();
        this.btnDisplaySettings.setAlignmentX(0.5f);
        this.pnlAppControl = new JPanel();
        btnConfig = new JButton();
        btnConfig.setAlignmentX(0.5f);
        this.btnCloseProgram = new JButton();
        this.btnCloseProgram.setAlignmentX(0.5f);
        this.pnlDisplayHelp = new JPanel();
        this.pnlApplicationLog = new JPanel();
        this.scrollPaneLog = new JScrollPane();
        txtLogScroll = new JTextArea();
        this.lblRadonScoutQuickCal = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Rad Elec Recon Download Tool");
        this.setIconImages(null);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainMenuUI.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        lblSystemConsole.setFont(new Font("Calibri", 0, 12));
        lblSystemConsole.setHorizontalAlignment(0);
        lblSystemConsole.setText("System Console");
        this.getContentPane().add((Component)lblSystemConsole, new AbsoluteConstraints(90, 260, 181, -1));
        this.btnConnect.setFont(new Font("Calibri", 1, 24));
        this.btnConnect.setText("Connect");
        this.btnConnect.setToolTipText("Click here to search for the Recon CRM.");
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnConnectActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.btnConnect, new AbsoluteConstraints(90, 200, 181, 48));
        lblVersion.setFont(new Font("Calibri", 1, 18));
        lblVersion.setText("v?");
        lblVersion.setToolTipText("");
        this.getContentPane().add((Component)lblVersion, new AbsoluteConstraints(150, 130, -1, -1));
        this.limiterLabel.setForeground(new Color(204, 0, 0));
        this.limiterLabel.setText("COUNT LIMITER = OFF");
        this.getContentPane().add((Component)this.limiterLabel, new AbsoluteConstraints(110, 170, -1, -1));
        this.limiterLabel.getAccessibleContext().setAccessibleName("limiterLabel");
        lblFinalAvg.setFont(new Font("Calibri", 1, 24));
        this.getContentPane().add((Component)lblFinalAvg, new AbsoluteConstraints(680, 310, 360, 30));
        this.pnlMainDeployment.setBorder(BorderFactory.createTitledBorder("Deployment"));
        this.pnlMainDeployment.setLayout((LayoutManager)new AbsoluteLayout());
        this.lblTestSiteInfo1.setFont(new Font("Calibri", 1, 14));
        this.lblTestSiteInfo1.setText("Customer Information");
        this.pnlMainDeployment.add((Component)this.lblTestSiteInfo1, new AbsoluteConstraints(17, 45, 223, 17));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        txtCustomerInfo.setColumns(20);
        txtCustomerInfo.setRows(5);
        txtCustomerInfo.setTabSize(4);
        txtCustomerInfo.setBorder(null);
        this.jScrollPane2.setViewportView(txtCustomerInfo);
        txtCustomerInfo.getAccessibleContext().setAccessibleName("");
        this.pnlMainDeployment.add((Component)this.jScrollPane2, new AbsoluteConstraints(17, 68, 170, 67));
        this.lblTestSiteInfo.setFont(new Font("Calibri", 1, 14));
        this.lblTestSiteInfo.setText("Test Site Information");
        this.pnlMainDeployment.add((Component)this.lblTestSiteInfo, new AbsoluteConstraints(17, 147, 223, 17));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        txtTestSiteInfo.setColumns(20);
        txtTestSiteInfo.setRows(5);
        txtTestSiteInfo.setTabSize(4);
        txtTestSiteInfo.setBorder(null);
        this.jScrollPane1.setViewportView(txtTestSiteInfo);
        this.pnlMainDeployment.add((Component)this.jScrollPane1, new AbsoluteConstraints(17, 174, 170, 66));
        this.lblLocation.setFont(new Font("Calibri", 1, 14));
        this.lblLocation.setText("Test Location");
        this.pnlMainDeployment.add((Component)this.lblLocation, new AbsoluteConstraints(17, 252, -1, 20));
        this.lblMainWeather.setFont(new Font("Calibri", 1, 14));
        this.lblMainWeather.setText("Weather");
        this.pnlMainDeployment.add((Component)this.lblMainWeather, new AbsoluteConstraints(205, 311, -1, -1));
        this.lblMainProtocol.setFont(new Font("Calibri", 1, 14));
        this.lblMainProtocol.setText("Protocol");
        this.pnlMainDeployment.add((Component)this.lblMainProtocol, new AbsoluteConstraints(205, 252, -1, -1));
        this.lblMainMitigation.setFont(new Font("Calibri", 1, 14));
        this.lblMainMitigation.setText("Mitigation");
        this.pnlMainDeployment.add((Component)this.lblMainMitigation, new AbsoluteConstraints(205, 371, -1, -1));
        this.lblMainTampering.setFont(new Font("Calibri", 1, 14));
        this.lblMainTampering.setText("Tampering");
        this.pnlMainDeployment.add((Component)this.lblMainTampering, new AbsoluteConstraints(205, 188, -1, -1));
        this.lblMainComment.setFont(new Font("Calibri", 1, 14));
        this.lblMainComment.setText("Comment");
        this.pnlMainDeployment.add((Component)this.lblMainComment, new AbsoluteConstraints(209, 429, -1, -1));
        txtLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.txtLocationActionPerformed(evt);
            }
        });
        this.pnlMainDeployment.add((Component)txtLocation, new AbsoluteConstraints(17, 276, 170, 26));
        this.pnlMainDeployment.add((Component)txtMainTampering, new AbsoluteConstraints(205, 212, 218, 28));
        this.pnlMainDeployment.add((Component)txtMainProtocol, new AbsoluteConstraints(205, 276, 218, 26));
        this.pnlMainDeployment.add((Component)txtMainWeather, new AbsoluteConstraints(205, 335, 218, 30));
        txtMainMitigation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.txtMainMitigationActionPerformed(evt);
            }
        });
        this.pnlMainDeployment.add((Component)txtMainMitigation, new AbsoluteConstraints(205, 394, 218, 29));
        this.lblMainDeployedBy.setFont(new Font("Calibri", 1, 14));
        this.lblMainDeployedBy.setText("Deployed By");
        this.pnlMainDeployment.add((Component)this.lblMainDeployedBy, new AbsoluteConstraints(17, 311, -1, -1));
        this.pnlMainDeployment.add((Component)txtMainDeployedBy, new AbsoluteConstraints(17, 335, 170, 30));
        this.lblMainRetrievedBy.setFont(new Font("Calibri", 1, 14));
        this.lblMainRetrievedBy.setText("Retrieved By");
        this.pnlMainDeployment.add((Component)this.lblMainRetrievedBy, new AbsoluteConstraints(17, 371, -1, -1));
        this.pnlMainDeployment.add((Component)txtMainRetrievedBy, new AbsoluteConstraints(17, 394, 170, 29));
        this.lblMainAnalyzedBy.setFont(new Font("Calibri", 1, 14));
        this.lblMainAnalyzedBy.setText("Analyzed By");
        this.pnlMainDeployment.add((Component)this.lblMainAnalyzedBy, new AbsoluteConstraints(17, 429, -1, -1));
        this.pnlMainDeployment.add((Component)txtMainAnalyzedBy, new AbsoluteConstraints(17, 450, 170, 29));
        this.pnlMainDeployment.add((Component)txtMainComment, new AbsoluteConstraints(205, 450, 218, 29));
        pnlStartEndDate.setLayout((LayoutManager)new AbsoluteLayout());
        this.lblStartDate.setFont(new Font("Calibri", 0, 12));
        this.lblStartDate.setText("Start Date/Time:");
        pnlStartEndDate.add((Component)this.lblStartDate, new AbsoluteConstraints(12, 12, -1, -1));
        this.lblEndDateTime.setFont(new Font("Calibri", 0, 12));
        this.lblEndDateTime.setText("End Date/Time:");
        pnlStartEndDate.add((Component)this.lblEndDateTime, new AbsoluteConstraints(12, 33, -1, -1));
        this.lblTotalHours.setFont(new Font("Calibri", 0, 12));
        this.lblTotalHours.setText("Total Hours:");
        pnlStartEndDate.add((Component)this.lblTotalHours, new AbsoluteConstraints(12, 54, -1, -1));
        btnRange.setFont(new Font("Calibri", 0, 12));
        btnRange.setText("Range");
        btnRange.setToolTipText("Temporarily edit the start and end times of the open test.");
        btnRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnRangeActionPerformed(evt);
            }
        });
        pnlStartEndDate.add((Component)btnRange, new AbsoluteConstraints(77, 75, -1, 19));
        lblStartDateTimeDynamic.setFont(new Font("Calibri", 0, 12));
        pnlStartEndDate.add((Component)lblStartDateTimeDynamic, new AbsoluteConstraints(107, 12, -1, -1));
        lblEndDateTimeDynamic.setFont(new Font("Calibri", 0, 12));
        pnlStartEndDate.add((Component)lblEndDateTimeDynamic, new AbsoluteConstraints(108, 33, -1, -1));
        lblTotalHoursDynamic.setFont(new Font("Calibri", 0, 12));
        pnlStartEndDate.add((Component)lblTotalHoursDynamic, new AbsoluteConstraints(108, 54, -1, -1));
        this.pnlMainDeployment.add((Component)pnlStartEndDate, new AbsoluteConstraints(205, 29, -1, -1));
        btnMainImages.setFont(new Font("Calibri", 0, 12));
        btnMainImages.setText("Images");
        btnMainImages.setToolTipText("Select images to add to the report.");
        btnMainImages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnMainImagesActionPerformed(evt);
            }
        });
        this.pnlMainDeployment.add((Component)btnMainImages, new AbsoluteConstraints(322, 143, 78, -1));
        this.btnTestDetails.setFont(new Font("Calibri", 0, 12));
        this.btnTestDetails.setText("Details");
        this.btnTestDetails.setToolTipText("Show test details for the currently opened file.");
        this.btnTestDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnTestDetailsActionPerformed(evt);
            }
        });
        this.pnlMainDeployment.add((Component)this.btnTestDetails, new AbsoluteConstraints(230, 143, 78, -1));
        this.getContentPane().add((Component)this.pnlMainDeployment, new AbsoluteConstraints(0, 340, 440, 490));
        this.pnlFileMgmt.setBorder(BorderFactory.createTitledBorder("File Management"));
        this.pnlFileMgmt.setLayout(new BoxLayout(this.pnlFileMgmt, 1));
        this.btnOpenSavedFile.setFont(new Font("Calibri", 0, 12));
        this.btnOpenSavedFile.setText("Open Saved File");
        this.btnOpenSavedFile.setToolTipText("Open previously downloaded data file.");
        this.btnOpenSavedFile.setMaximumSize(new Dimension(145, 25));
        this.btnOpenSavedFile.setMinimumSize(new Dimension(145, 25));
        this.btnOpenSavedFile.setName("");
        this.btnOpenSavedFile.setPreferredSize(new Dimension(145, 25));
        this.btnOpenSavedFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnOpenSavedFileActionPerformed(evt);
            }
        });
        this.pnlFileMgmt.add(this.btnOpenSavedFile);
        this.btnOpenPDF.setFont(new Font("Calibri", 0, 12));
        this.btnOpenPDF.setText("Open PDF Folder");
        this.btnOpenPDF.setToolTipText("Opens the PDF directory, where your generated reports are stored.");
        this.btnOpenPDF.setMaximumSize(new Dimension(145, 25));
        this.btnOpenPDF.setMinimumSize(new Dimension(145, 25));
        this.btnOpenPDF.setName("");
        this.btnOpenPDF.setPreferredSize(new Dimension(145, 25));
        this.btnOpenPDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnOpenPDFActionPerformed(evt);
            }
        });
        this.pnlFileMgmt.add(this.btnOpenPDF);
        btnGeneratePDF.setFont(new Font("Calibri", 0, 12));
        btnGeneratePDF.setToolTipText("Generate PDF from current results.");
        btnGeneratePDF.setLabel("Generate PDF");
        btnGeneratePDF.setMaximumSize(new Dimension(145, 25));
        btnGeneratePDF.setMinimumSize(new Dimension(145, 25));
        btnGeneratePDF.setName("");
        btnGeneratePDF.setPreferredSize(new Dimension(145, 25));
        btnGeneratePDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnGeneratePDFActionPerformed(evt);
            }
        });
        this.pnlFileMgmt.add(btnGeneratePDF);
        btnCloseFile.setFont(new Font("Calibri", 0, 12));
        btnCloseFile.setText("Close File");
        btnCloseFile.setMaximumSize(new Dimension(145, 25));
        btnCloseFile.setMinimumSize(new Dimension(145, 25));
        btnCloseFile.setPreferredSize(new Dimension(145, 25));
        btnCloseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnCloseFileActionPerformed(evt);
            }
        });
        this.pnlFileMgmt.add(btnCloseFile);
        this.btnExport.setFont(new Font("Calibri", 0, 12));
        this.btnExport.setText("Export");
        this.btnExport.setToolTipText("Export open radon test to other formats.");
        this.btnExport.setMaximumSize(new Dimension(145, 25));
        this.btnExport.setMinimumSize(new Dimension(145, 25));
        this.btnExport.setPreferredSize(new Dimension(145, 25));
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnExportActionPerformed(evt);
            }
        });
        this.pnlFileMgmt.add(this.btnExport);
        this.btnBackup.setFont(new Font("Calibri", 0, 12));
        this.btnBackup.setText("Backup");
        this.btnBackup.setToolTipText("Create zip archive of all user files for backup or transport to another computer.");
        this.btnBackup.setMaximumSize(new Dimension(145, 25));
        this.btnBackup.setMinimumSize(new Dimension(145, 25));
        this.btnBackup.setPreferredSize(new Dimension(145, 25));
        this.btnBackup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnBackupActionPerformed(evt);
            }
        });
        this.pnlFileMgmt.add(this.btnBackup);
        this.btnRestore.setFont(new Font("Calibri", 0, 12));
        this.btnRestore.setText("Restore");
        this.btnRestore.setToolTipText("Restore settings and files that were archived with the Backup button in the Recon Download Tool.");
        this.btnRestore.setMaximumSize(new Dimension(145, 25));
        this.btnRestore.setMinimumSize(new Dimension(145, 25));
        this.btnRestore.setPreferredSize(new Dimension(145, 25));
        this.btnRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnRestoreActionPerformed(evt);
            }
        });
        this.pnlFileMgmt.add(this.btnRestore);
        this.getContentPane().add((Component)this.pnlFileMgmt, new AbsoluteConstraints(840, 0, 170, 300));
        this.pnlReconStatus.setBorder(BorderFactory.createTitledBorder("Device Status"));
        cboSessionSelect.setFont(new Font("Calibri", 1, 14));
        cboSessionSelect.setToolTipText("Select a data session to download.");
        cboSessionSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.cboSessionSelectActionPerformed(evt);
            }
        });
        this.txtNewFileName.setToolTipText("Enter preferred filename for the downloaded test. Do not include an extension.");
        this.chkUseStreetAddressForFilename.setFont(new Font("Calibri", 1, 14));
        this.chkUseStreetAddressForFilename.setText("Use street address for filename?");
        this.chkUseStreetAddressForFilename.setToolTipText("Check to use the first line of Test Site Information.");
        lblFirmwareVersion.setFont(new Font("Calibri", 0, 12));
        lblFirmwareVersion.setText("Firmware v");
        lblReconSN.setFont(new Font("Calibri", 0, 12));
        lblReconSN.setText("Device S/N:");
        lblCalibrationDate.setFont(new Font("Calibri", 0, 12));
        lblCalibrationDate.setText("Calibration Date:");
        lblDataSessions.setFont(new Font("Calibri", 0, 12));
        lblDataSessions.setHorizontalAlignment(2);
        lblDataSessions.setText("Data Sessions:");
        lblDataSessions.setHorizontalTextPosition(0);
        lblDataSessions.setMaximumSize(new Dimension(181, 16));
        lblDataSessions.setMinimumSize(new Dimension(181, 16));
        lblDataSessions.setName("");
        lblDataSessions.setPreferredSize(new Dimension(181, 16));
        lblCalibrationDue.setFont(new Font("Calibri", 0, 12));
        lblCalibrationDue.setText("Calibration Due:");
        this.btnDownloadSession.setFont(new Font("Calibri", 1, 24));
        this.btnDownloadSession.setForeground(new Color(51, 51, 255));
        this.btnDownloadSession.setText("Download");
        this.btnDownloadSession.setToolTipText("Download current session from Recon.");
        this.btnDownloadSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnDownloadSessionActionPerformed(evt);
            }
        });
        this.lblStatusNoRecon.setIcon(new ImageIcon(this.getClass().getResource("/MainMenu/no_recon_connected.png")));
        GroupLayout pnlReconStatusLayout = new GroupLayout(this.pnlReconStatus);
        this.pnlReconStatus.setLayout(pnlReconStatusLayout);
        pnlReconStatusLayout.setHorizontalGroup(pnlReconStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlReconStatusLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.lblStatusNoRecon).addGap(42, 42, 42)).addGroup(pnlReconStatusLayout.createSequentialGroup().addContainerGap().addGroup(pnlReconStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkUseStreetAddressForFilename).addComponent(this.txtNewFileName, -2, 169, -2).addComponent(lblFirmwareVersion, -2, 104, -2).addComponent(lblReconSN, -2, 104, -2).addComponent(lblCalibrationDate).addComponent(lblDataSessions, -2, 118, -2).addComponent(lblCalibrationDue).addComponent(cboSessionSelect, -2, 169, -2).addGroup(pnlReconStatusLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.btnDownloadSession, -2, 153, -2))).addContainerGap(22, Short.MAX_VALUE)));
        pnlReconStatusLayout.setVerticalGroup(pnlReconStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlReconStatusLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(lblReconSN).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblFirmwareVersion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblCalibrationDate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblCalibrationDue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblDataSessions, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblStatusNoRecon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(cboSessionSelect, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtNewFileName, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkUseStreetAddressForFilename).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDownloadSession, -2, 48, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.pnlReconStatus, new AbsoluteConstraints(350, 0, 250, 300));
        pnlGraph.setBorder(BorderFactory.createTitledBorder("Graph"));
        pnlGraph.setLayout(new BorderLayout());
        this.getContentPane().add((Component)pnlGraph, new AbsoluteConstraints(450, 340, 740, 440));
        lblLoadedFile.setFont(new Font("Calibri", 0, 12));
        lblLoadedFile.setHorizontalAlignment(0);
        lblLoadedFile.setText("Loaded File");
        lblLoadedFile.setHorizontalTextPosition(0);
        lblLoadedFile.setMaximumSize(new Dimension(181, 16));
        lblLoadedFile.setMinimumSize(new Dimension(181, 16));
        lblLoadedFile.setName("");
        lblLoadedFile.setPreferredSize(new Dimension(181, 16));
        this.getContentPane().add((Component)lblLoadedFile, new AbsoluteConstraints(710, 790, 181, -1));
        lblLoadedFileName.setFont(new Font("Calibri", 1, 12));
        lblLoadedFileName.setHorizontalAlignment(0);
        lblLoadedFileName.setText("No File Loaded");
        lblLoadedFileName.setHorizontalTextPosition(0);
        lblLoadedFileName.setMaximumSize(new Dimension(181, 16));
        lblLoadedFileName.setMinimumSize(new Dimension(181, 16));
        lblLoadedFileName.setName("");
        lblLoadedFileName.setPreferredSize(new Dimension(181, 16));
        this.getContentPane().add((Component)lblLoadedFileName, new AbsoluteConstraints(710, 810, 181, -1));
        this.pnlReconButtons.setBorder(BorderFactory.createTitledBorder("Device Operations"));
        this.pnlReconButtons.setLayout(new BoxLayout(this.pnlReconButtons, 1));
        this.btnEraseReconData.setFont(new Font("Calibri", 0, 12));
        this.btnEraseReconData.setText("Clear Session");
        this.btnEraseReconData.setToolTipText("Clears current data session from Recon.");
        this.btnEraseReconData.setMaximumSize(new Dimension(175, 25));
        this.btnEraseReconData.setMinimumSize(new Dimension(175, 25));
        this.btnEraseReconData.setPreferredSize(new Dimension(175, 25));
        this.btnEraseReconData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnEraseReconDataActionPerformed(evt);
            }
        });
        this.pnlReconButtons.add(this.btnEraseReconData);
        this.btnClearSession.setFont(new Font("Calibri", 0, 12));
        this.btnClearSession.setText("Clear Current Session (:CD)");
        this.btnClearSession.setMaximumSize(new Dimension(175, 25));
        this.btnClearSession.setMinimumSize(new Dimension(175, 25));
        this.btnClearSession.setPreferredSize(new Dimension(175, 25));
        this.btnClearSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnClearSessionActionPerformed(evt);
            }
        });
        this.pnlReconButtons.add(this.btnClearSession);
        this.btnClearMemory.setFont(new Font("Calibri", 0, 12));
        this.btnClearMemory.setText("Reset Memory");
        this.btnClearMemory.setToolTipText("Reset memory to 0. Next test will overwrite previous data! Unless you have a specific reason to do this, use Clear Session!");
        this.btnClearMemory.setMaximumSize(new Dimension(175, 25));
        this.btnClearMemory.setMinimumSize(new Dimension(175, 25));
        this.btnClearMemory.setPreferredSize(new Dimension(175, 25));
        this.btnClearMemory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnClearMemoryActionPerformed(evt);
            }
        });
        this.pnlReconButtons.add(this.btnClearMemory);
        this.btnAllDataDump.setFont(new Font("Calibri", 0, 12));
        this.btnAllDataDump.setLabel("All Data Dump");
        this.btnAllDataDump.setMaximumSize(new Dimension(175, 25));
        this.btnAllDataDump.setMinimumSize(new Dimension(175, 25));
        this.btnAllDataDump.setPreferredSize(new Dimension(175, 25));
        this.btnAllDataDump.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnAllDataDumpActionPerformed(evt);
            }
        });
        this.pnlReconButtons.add(this.btnAllDataDump);
        this.btnClearTamperFlag.setFont(new Font("Calibri", 0, 12));
        this.btnClearTamperFlag.setText("Clear Tamper Flag");
        this.btnClearTamperFlag.setMaximumSize(new Dimension(175, 25));
        this.btnClearTamperFlag.setMinimumSize(new Dimension(175, 25));
        this.btnClearTamperFlag.setPreferredSize(new Dimension(175, 25));
        this.btnClearTamperFlag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnClearTamperFlagActionPerformed(evt);
            }
        });
        this.pnlReconButtons.add(this.btnClearTamperFlag);
        this.btnSyncTime.setFont(new Font("Calibri", 0, 12));
        this.btnSyncTime.setToolTipText("Sync Recon time to PC time. Must have Recon connected.");
        this.btnSyncTime.setLabel("Sync Time");
        this.btnSyncTime.setMaximumSize(new Dimension(175, 25));
        this.btnSyncTime.setMinimumSize(new Dimension(175, 25));
        this.btnSyncTime.setPreferredSize(new Dimension(175, 25));
        this.btnSyncTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnSyncTimeActionPerformed(evt);
            }
        });
        this.pnlReconButtons.add(this.btnSyncTime);
        this.btnDisplaySettings.setFont(new Font("Calibri", 0, 12));
        this.btnDisplaySettings.setText("Display Settings");
        this.btnDisplaySettings.setMaximumSize(new Dimension(175, 25));
        this.btnDisplaySettings.setMinimumSize(new Dimension(175, 25));
        this.btnDisplaySettings.setPreferredSize(new Dimension(175, 25));
        this.btnDisplaySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnDisplaySettingsActionPerformed(evt);
            }
        });
        this.pnlReconButtons.add(this.btnDisplaySettings);
        this.getContentPane().add((Component)this.pnlReconButtons, new AbsoluteConstraints(620, 0, 200, 300));
        this.pnlAppControl.setBorder(BorderFactory.createTitledBorder("App"));
        this.pnlAppControl.setLayout(new BoxLayout(this.pnlAppControl, 1));
        btnConfig.setFont(new Font("Calibri", 0, 12));
        btnConfig.setText("Config");
        btnConfig.setMaximumSize(new Dimension(125, 25));
        btnConfig.setMinimumSize(new Dimension(125, 25));
        btnConfig.setPreferredSize(new Dimension(125, 25));
        btnConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnConfigActionPerformed(evt);
            }
        });
        this.pnlAppControl.add(btnConfig);
        this.btnCloseProgram.setFont(new Font("Calibri", 0, 12));
        this.btnCloseProgram.setText("Exit Program");
        this.btnCloseProgram.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.btnCloseProgram.setMaximumSize(new Dimension(125, 25));
        this.btnCloseProgram.setMinimumSize(new Dimension(125, 25));
        this.btnCloseProgram.setPreferredSize(new Dimension(125, 25));
        this.btnCloseProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuUI.this.btnCloseProgramActionPerformed(evt);
            }
        });
        this.pnlAppControl.add(this.btnCloseProgram);
        this.getContentPane().add((Component)this.pnlAppControl, new AbsoluteConstraints(1030, 0, 150, 300));
        this.pnlDisplayHelp.setBorder(BorderFactory.createTitledBorder("Online Manual"));
        GroupLayout pnlDisplayHelpLayout = new GroupLayout(this.pnlDisplayHelp);
        this.pnlDisplayHelp.setLayout(pnlDisplayHelpLayout);
        pnlDisplayHelpLayout.setHorizontalGroup(pnlDisplayHelpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 370, Short.MAX_VALUE));
        pnlDisplayHelpLayout.setVerticalGroup(pnlDisplayHelpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 276, Short.MAX_VALUE));
        this.getContentPane().add((Component)this.pnlDisplayHelp, new AbsoluteConstraints(1200, 0, 380, 300));
        this.pnlApplicationLog.setBorder(BorderFactory.createTitledBorder("App Log"));
        this.pnlApplicationLog.setLayout(new BorderLayout());
        txtLogScroll.setEditable(false);
        txtLogScroll.setColumns(20);
        txtLogScroll.setRows(5);
        this.scrollPaneLog.setViewportView(txtLogScroll);
        this.pnlApplicationLog.add((Component)this.scrollPaneLog, "Center");
        this.getContentPane().add((Component)this.pnlApplicationLog, new AbsoluteConstraints(1200, 340, 380, 490));
        this.lblRadonScoutQuickCal.setHorizontalAlignment(0);
        this.lblRadonScoutQuickCal.setIcon(new ImageIcon(this.getClass().getResource("/MainMenu/RadElecReconDownloadTool.png")));
        this.getContentPane().add((Component)this.lblRadonScoutQuickCal, new AbsoluteConstraints(40, -20, 270, 180));
        this.setSize(new Dimension(1591, 863));
        this.setLocationRelativeTo(null);
    }

    private void btnConnectActionPerformed(ActionEvent evt) {
        AppUI.ConnectWorker worker = new AppUI.ConnectWorker();
        worker.execute();
    }

    private void btnClearMemoryActionPerformed(ActionEvent evt) {
        AppUI.ClearReconMemory worker = new AppUI.ClearReconMemory();
        worker.execute();
    }

    private void btnClearSessionActionPerformed(ActionEvent evt) {
        AppUI.ClearCurrentSession worker = new AppUI.ClearCurrentSession();
        worker.execute();
    }

    private void btnAllDataDumpActionPerformed(ActionEvent evt) {
        AppUI.AllDataDump worker = new AppUI.AllDataDump();
        worker.execute();
    }

    private void btnConfigActionPerformed(ActionEvent evt) {
        Config frameOptions = new Config();
        frameOptions.setDefaultCloseOperation(2);
        frameOptions.setLocationRelativeTo(this);
        frameOptions.setVisible(true);
    }

    private void btnDownloadSessionActionPerformed(ActionEvent evt) {
        AppUI.DownloadSession worker = new AppUI.DownloadSession();
        worker.execute();
    }

    private void btnOpenSavedFileActionPerformed(ActionEvent evt) {
        final JFileChooser SavedReconTXT_Dialog = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("RDT Data Files (txt, csv, json)", "txt", "csv", "json");
        SavedReconTXT_Dialog.setFileFilter(filter);
        File workingDirectory = InitDirs.dataDir;
        SavedReconTXT_Dialog.setCurrentDirectory(workingDirectory);
        int returnVal = SavedReconTXT_Dialog.showOpenDialog(null);
        if (returnVal == 0) {
            lblLoadedFile.setText("Loaded File");
            lblLoadedFile.setVisible(true);
            lblLoadedFileName.setVisible(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        LoadSavedFile.main(SavedReconTXT_Dialog.getSelectedFile().getCanonicalPath());
                    }
                    catch (IOException ex) {
                        Logging.main("ERROR: Unable to determine file path for the loaded file!");
                    }
                }
            }).start();
        } else {
            lblLoadedFile.setVisible(false);
            lblLoadedFileName.setVisible(false);
        }
    }

    private void btnGeneratePDFActionPerformed(ActionEvent evt) {
        AppUI.GeneratePDF worker = new AppUI.GeneratePDF();
        worker.execute();
    }

    private void btnEraseReconDataActionPerformed(ActionEvent evt) {
        AppUI.ClearCurrentSession worker = new AppUI.ClearCurrentSession();
        worker.execute();
    }

    private void btnSyncTimeActionPerformed(ActionEvent evt) {
        AppUI.SyncReconTime worker = new AppUI.SyncReconTime();
        worker.execute();
    }

    private void btnOpenPDFActionPerformed(ActionEvent evt) {
        Desktop desktop = null;
        try {
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
                desktop.open(InitDirs.reportsDir);
            } else {
                Logging.main("ERROR: Opening PDF Folder!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void btnClearTamperFlagActionPerformed(ActionEvent evt) {
        AppUI.ClearTamperStatus worker = new AppUI.ClearTamperStatus();
        worker.execute();
    }

    private void txtLocationActionPerformed(ActionEvent evt) {
    }

    private void btnCloseProgramActionPerformed(ActionEvent evt) {
        this.CloseFile();
        System.exit(0);
    }

    private void cboSessionSelectActionPerformed(ActionEvent evt) {
        ReconProtocol.currentSession = cboSessionSelect.getSelectedIndex();
        TMProtocol.currentSession = cboSessionSelect.getSelectedIndex();
        this.RefreshDefaultFileName();
        this.chkUseStreetAddressForFilename.setSelected(false);
    }

    private void btnCloseFileActionPerformed(ActionEvent evt) {
        this.CloseFile();
        MainMenuUI.RefreshDeploymentFields();
    }

    private void txtMainMitigationActionPerformed(ActionEvent evt) {
    }

    private void btnDisplaySettingsActionPerformed(ActionEvent evt) {
        FlagForm flagOptions = new FlagForm();
        flagOptions.setDefaultCloseOperation(2);
        flagOptions.setLocationRelativeTo(this);
        if (flagOptions.reconConnected) {
            flagOptions.setVisible(true);
        } else {
            flagOptions.dispose();
        }
    }

    private void btnRangeActionPerformed(ActionEvent evt) {
        if (LoadSavedFile.dataType != LoadSavedFile.DataType.RECON) {
            Logging.main("Setting a data range is currently only supported for Recon data.");
            return;
        }
        RangeSelectionFrame frmRange = new RangeSelectionFrame();
        frmRange.setLocationRelativeTo(this);
        frmRange.setVisible(true);
    }

    private void btnMainImagesActionPerformed(ActionEvent evt) {
        ImageSelectionPanel frameImages = new ImageSelectionPanel();
        frameImages.setDefaultCloseOperation(2);
        frameImages.setLocationRelativeTo(this);
        frameImages.setVisible(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.CloseFile();
    }

    private void btnExportActionPerformed(ActionEvent evt) {
        this.ShowExportDialog(LoadSavedFile.strOpenFileName);
    }

    private void btnTestDetailsActionPerformed(ActionEvent evt) {
        TestDetails frameTestDetails = new TestDetails();
        TestDetails.txtRDTVersion.setText(LoadSavedFile.strRDTVersion);
        TestDetails.txtFirmwareVersion.setText(LoadSavedFile.strFirmwareVersion);
        TestDetails.txtInstrumentSerial.setText(LoadSavedFile.strInstrumentSerial);
        TestDetails.txtCalibrationDate.setText(LoadSavedFile.strCalDate);
        TestDetails.txtCalibrationFactor1.setText(this.cfFormat.format(LoadSavedFile.LoadedReconCF1));
        TestDetails.txtCalibrationFactor2.setText(this.cfFormat.format(LoadSavedFile.LoadedReconCF2));
        frameTestDetails.setVisible(true);
    }

    private void btnBackupActionPerformed(ActionEvent evt) {
        this.PerformUserDataBackup();
    }

    private void btnRestoreActionPerformed(ActionEvent evt) {
        this.PerformUserDataRestore();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension minScreenSizeForUI;
                block12: {
                    File dateJSONFile;
                    File pdfJSONFile;
                    File chartJSONFile;
                    minScreenSizeForUI = new Dimension(1600, 900);
                    InitDirs.main();
                    File configJSONFile = new File(InitDirs.configDir + File.separator + "config.json");
                    if (!configJSONFile.exists()) {
                        Logging.main("Creating config.json.");
                        AppUI tempAppUI = new AppUI();
                        tempAppUI.createConfigJSON();
                        tempAppUI = null;
                    }
                    if (!(chartJSONFile = new File(InitDirs.configDir + File.separator + "chart.json")).exists()) {
                        Logging.main("Creating chart.json.");
                        AppUI tempAppUI = new AppUI();
                        tempAppUI.createChartJSON();
                        tempAppUI = null;
                    }
                    if (!(pdfJSONFile = new File(InitDirs.configDir + File.separator + "pdf.json")).exists()) {
                        Logging.main("Creating pdf.json.");
                        AppUI tempAppUI = new AppUI();
                        tempAppUI.createPDFJSON();
                        tempAppUI = null;
                    }
                    if (!(dateJSONFile = new File(InitDirs.configDir + File.separator + "datefmt.json")).exists()) {
                        Logging.main("Creating datefmt.json.");
                        UIManager.LookAndFeelInfo[] tempAppUI = new AppUI();
                        tempAppUI.createDateFmtJSON();
                        tempAppUI = null;
                    }
                    AppUI.parseConfigJSON();
                    AppUI.parseChartJSON();
                    AppUI.parsePDFJSON();
                    AppUI.parseDateFmtJSON();
                    try {
                        if (AppUI.strJavaLookAndFeel.equals("FlatLaf") && MainMenuUI.parseThemesJSON(InitDirs.appDir + "themes.json")) {
                            MainMenuUI.setTheme(themeFullyQualifiedClassNames.get(AppUI.strFlatLafTheme));
                            flatLafThemesLoaded = true;
                            break block12;
                        }
                        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                            if (!AppUI.strJavaLookAndFeel.equals(info.getName())) continue;
                            UIManager.setLookAndFeel(info.getClassName());
                            break;
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        Logger.getLogger(MainMenuUI.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (InstantiationException ex) {
                        Logger.getLogger(MainMenuUI.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(MainMenuUI.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (UnsupportedLookAndFeelException ex) {
                        Logger.getLogger(MainMenuUI.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                Dimension userScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
                if (!AppUI.forceMainMenuUI && (userScreenSize.getWidth() < minScreenSizeForUI.getWidth() || userScreenSize.getHeight() < minScreenSizeForUI.getHeight())) {
                    Logging.main("Screen size too small for UI. Forcing Legacy Mode.");
                    AppUI.usingLegacyUI = true;
                    Config tempConfig = new Config();
                    tempConfig.setVisible(false);
                    tempConfig.UpdateConfigLegacyUI();
                    tempConfig.dispose();
                }
                appUI = AppUI.usingLegacyUI ? new LegacyUI() : new MainMenuUI();
                appUI.SetDateFormats();
                appUI.setDefaultCloseOperation(2);
                appUI.setVisible(true);
            }
        });
    }

    public static void setTheme(String newTheme) {
        try {
            Class<?> unknown = Class.forName(newTheme);
            Method method = unknown.getMethod("setup", new Class[0]);
            method.invoke(unknown, new Object[0]);
        }
        catch (ClassNotFoundException cnfEx) {
            Logging.main("ClassNotFoundException caught when invoking MainMenuUI.setTheme()! Class Name: " + newTheme);
        }
        catch (NoSuchMethodException nsmEx) {
            Logging.main("NoSuchMethodException caught when invoking MainMenuUI.setTheme()!");
        }
        catch (IllegalAccessException iaEx) {
            Logging.main("IllegalAccessException caught when invoking MainMenuUI.setTheme()!");
        }
        catch (InvocationTargetException itEx) {
            Logging.main("InvocationTargetException caught when invoking MainMenuUI.setTheme()!");
        }
    }

    public static void setTheme(String newTheme, JFrame recipient) {
        try {
            Class<?> unknown = Class.forName(newTheme);
            Method method = unknown.getMethod("setup", new Class[0]);
            method.invoke(unknown, new Object[0]);
            SwingUtilities.updateComponentTreeUI(recipient);
        }
        catch (ClassNotFoundException cnfEx) {
            Logging.main("ClassNotFoundException caught when invoking MainMenuUI.setTheme()! Class Name: " + newTheme);
        }
        catch (NoSuchMethodException nsmEx) {
            Logging.main("NoSuchMethodException caught when invoking MainMenuUI.setTheme()!");
        }
        catch (IllegalAccessException iaEx) {
            Logging.main("IllegalAccessException caught when invoking MainMenuUI.setTheme()!");
        }
        catch (InvocationTargetException itEx) {
            Logging.main("InvocationTargetException caught when invoking MainMenuUI.setTheme()!");
        }
    }

    private static boolean parseThemesJSON(String resourceFileName) {
        try {
            File themeResource = new File(resourceFileName);
            if (!themeResource.exists()) {
                Logging.main("Theme resource file " + themeResource.getName() + " could not be found. Setting look and feel to Java default.");
                return false;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(themeResource.getAbsolutePath())));
            StringBuilder sb = new StringBuilder();
            String currentLine = br.readLine();
            while (currentLine != null) {
                sb.append(currentLine);
                currentLine = br.readLine();
            }
            String strThemes = sb.toString();
            JSONObject objThemes = (JSONObject)JSONValue.parseWithException(strThemes);
            Set setAllKeyNames = objThemes.keySet();
            Iterator keyItr = setAllKeyNames.iterator();
            themeNames = new LinkedList();
            themeFullyQualifiedClassNames = new HashMap<String, String>();
            while (keyItr.hasNext()) {
                JSONObject tempObj = (JSONObject)objThemes.get(keyItr.next());
                themeNames.add((String)tempObj.get("name"));
                themeFullyQualifiedClassNames.put((String)tempObj.get("name"), (String)tempObj.get("className"));
            }
            return true;
        }
        catch (Exception anyEx) {
            Logging.main("Exception caught in MainMenuUI.parseThemesJSON()!");
            anyEx.printStackTrace();
            return false;
        }
    }

    private void PerformUserDataBackup() {
        JFileChooser backupDestFileChooser = new JFileChooser();
        backupDestFileChooser.setDialogTitle("Select Destination File");
        backupDestFileChooser.setCurrentDirectory(new File(InitDirs.userHomeDirectory));
        backupDestFileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter zipFilter = new FileNameExtensionFilter("Zip archive", "zip");
        backupDestFileChooser.setFileFilter(zipFilter);
        backupDestFileChooser.setSelectedFile(new File("RDT-backup.zip"));
        try {
            File finalFile = null;
            int selection = backupDestFileChooser.showSaveDialog(this);
            if (selection == 0) {
                finalFile = !backupDestFileChooser.getSelectedFile().getName().endsWith(".zip") ? new File(backupDestFileChooser.getSelectedFile().getAbsolutePath() + ".zip") : new File(backupDestFileChooser.getSelectedFile().getAbsolutePath());
                if (this.ShowFileExistsOptionPane(finalFile.getAbsolutePath())) {
                    String sourceDir = InitDirs.baseDir.getAbsolutePath();
                    FileOutputStream fos = new FileOutputStream(finalFile.getAbsolutePath());
                    ZipOutputStream zOut = new ZipOutputStream(fos);
                    File dirToZip = new File(sourceDir);
                    MainMenuUI.zipFile(dirToZip, dirToZip.getName(), zOut);
                    zOut.close();
                    fos.close();
                    Logging.main("Zip archive of all user data was created at: " + finalFile.getAbsolutePath());
                    return;
                }
                Logging.main("Export of user data cancelled.");
                return;
            }
        }
        catch (Exception anyEx) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    private void PerformUserDataRestore() {
        JFileChooser restoreSrcFileChooser = new JFileChooser();
        restoreSrcFileChooser.setDialogTitle("Select Restore File");
        restoreSrcFileChooser.setCurrentDirectory(new File(InitDirs.userHomeDirectory));
        restoreSrcFileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter zipFilter = new FileNameExtensionFilter("Zip archive", "zip");
        restoreSrcFileChooser.setFileFilter(zipFilter);
        try {
            int selection = restoreSrcFileChooser.showOpenDialog(this);
            if (selection == 0) {
                File destDir = new File(InitDirs.userHomeDirectory);
                String zipFile = restoreSrcFileChooser.getSelectedFile().getAbsolutePath();
                Logging.main("Unarchiving " + zipFile + " to " + destDir.getAbsolutePath());
                byte[] buffer = new byte[1024];
                ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    File newFile = MainMenuUI.newFile(destDir, zipEntry);
                    if (zipEntry.isDirectory()) {
                        if (!newFile.isDirectory() && !newFile.mkdirs()) {
                            throw new IOException("Failed to create directory " + newFile);
                        }
                    } else {
                        int len;
                        File parent = newFile.getParentFile();
                        if (!parent.isDirectory() && !parent.mkdirs()) {
                            throw new IOException("Failed to create directory " + parent);
                        }
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    zipEntry = zis.getNextEntry();
                }
                zis.closeEntry();
                zis.close();
                JOptionPane.showMessageDialog(this, "Restore is complete.\nPlease close and restart the Recon Download Tool.");
            }
        }
        catch (Exception anyEx) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isDirectory()) {
            File[] children;
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            for (File childFile : children = fileToZip.listFiles()) {
                if (childFile.getName().equals("logs") || childFile.getName().contains("graph.png")) continue;
                MainMenuUI.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    @Override
    public void EnableAllButtons(boolean boolEnableButtons) {
        super.EnableAllButtons(boolEnableButtons);
        this.btnBackup.setEnabled(boolEnableButtons);
        this.btnRestore.setEnabled(boolEnableButtons);
    }

    static {
        flatLafThemesLoaded = false;
    }
}

