/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.AppUI;
import MainMenu.CreateGraph;
import MainMenu.CreateJSONData;
import MainMenu.DataExporter;
import MainMenu.InitDirs;
import MainMenu.LegacyUI;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import MainMenu.RecoverFile;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class LoadSavedFile {
    public static ArrayList<ArrayList<String>> LoadedReconDataFile;
    public static double LoadedReconCF1;
    public static double LoadedReconCF2;
    public static ArrayList<Double> LoadedReconDataFile_Ch1RnC;
    public static ArrayList<Double> LoadedReconDataFile_Ch2RnC;
    public static String strTestSiteInfo;
    public static String strCustomerInfo;
    public static String strLocation;
    public static String strStartDate;
    public static String strEndDate;
    public static String strUnitSystem;
    public static String strInstrumentSerial;
    public static String strDeployedBy;
    public static String strRetrievedBy;
    public static String strAnalyzedBy;
    public static String strCalDate;
    public static String strReportProtocol;
    public static String strReportTampering;
    public static String strReportWeather;
    public static String strReportMitigation;
    public static String strReportComment;
    public static String strFirmwareVersion;
    public static String strRDTVersion;
    public static LinkedList<String> fileBuffer;
    public static LinkedList<String> rangeBuffer;
    public static String strOpenFileName;
    public static File inputFile;
    public static boolean isFileJSON;
    public static boolean isFileCSVText;
    public static boolean dataRangePresent;
    public static boolean rangeAverageFirstFourHours;
    public static boolean longTermMode;
    public static String userRangeStartAddress;
    public static String userRangeEndAddress;
    public static DataType dataType;

    public static void main(String ReconDataFile) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainMenuUI.appUI.CloseFile();
            }
        });
        LoadedReconDataFile = new ArrayList();
        LoadedReconCF1 = 6.0;
        LoadedReconCF2 = 6.0;
        strTestSiteInfo = "";
        strCustomerInfo = "";
        strLocation = "";
        strStartDate = "Unknown Start Date";
        strEndDate = "Unknown End Date";
        strUnitSystem = "US";
        strInstrumentSerial = "Unknown";
        strDeployedBy = "Unknown";
        strRetrievedBy = "Unknown";
        strAnalyzedBy = "Unknown";
        strCalDate = "Unknown";
        strReportProtocol = "Unknown";
        strReportTampering = "Unknown";
        strReportWeather = "Unknown";
        strReportMitigation = "Unknown";
        strReportComment = "Unknown";
        strFirmwareVersion = "Unknown";
        strRDTVersion = "Unknown";
        fileBuffer = new LinkedList();
        rangeBuffer = new LinkedList();
        strOpenFileName = "none";
        inputFile = new File(ReconDataFile);
        isFileJSON = false;
        isFileCSVText = false;
        dataRangePresent = false;
        rangeAverageFirstFourHours = false;
        longTermMode = false;
        dataType = DataType.UNKNOWN;
        int filenameIndex = ReconDataFile.lastIndexOf(".");
        String fileExtension = ReconDataFile.substring(filenameIndex + 1);
        isFileJSON = fileExtension.contains("json");
        isFileCSVText = fileExtension.contains("txt") || fileExtension.contains("csv");
        Logging.main("Attempting to open file of type: " + fileExtension);
        strOpenFileName = inputFile.getName().substring(0, inputFile.getName().lastIndexOf("."));
        try {
            strUnitSystem = AppUI.unitType;
            strInstrumentSerial = LoadSavedFile.getReconSerialFromFileName();
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(ReconDataFile)));
            String fileLine = br.readLine();
            while (fileLine != null) {
                if (!fileLine.isBlank()) {
                    fileBuffer.add(fileLine);
                }
                fileLine = br.readLine();
            }
            br.close();
            if (isFileCSVText && LoadSavedFile.RecoveryNecessary()) {
                if ((fileBuffer = RecoverFile.main(fileBuffer)).get(0) == "THIS IS AN EMPTY FILE") {
                    return;
                }
                if (fileBuffer.get(0) == "TMDATA") {
                    return;
                }
            }
            if (isFileJSON) {
                fileBuffer = LoadSavedFile.parseDataJSON(fileBuffer);
            }
            LoadSavedFile.ProcessBuffer(fileBuffer);
            if (isFileCSVText) {
                Logging.main("Exporting " + ReconDataFile + " to " + ReconDataFile.substring(0, filenameIndex) + ".json.");
                if (MainMenuUI.appUI.ShowFileExistsOptionPane(InitDirs.dataDir + File.separator + strOpenFileName + ".json")) {
                    CreateJSONData.main(DataExporter.GetTrimmedDataSession(fileBuffer), InitDirs.dataDir + File.separator + strOpenFileName + ".json", true, false);
                    if (AppUI.archiveImportedFiles) {
                        LoadSavedFile.ArchiveImportedFile(inputFile);
                    }
                    LoadSavedFile.main(InitDirs.dataDir + File.separator + strOpenFileName + ".json");
                } else {
                    Logging.main("LoadSavedFile: Cancelled import of txt/csv to json.");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (MainMenuUI.appUI instanceof MainMenuUI) {
                                MainMenuUI.appUI.btnTestDetails.setVisible(false);
                                AppUI.lblStartDateTimeDynamic.setText("");
                                AppUI.lblEndDateTimeDynamic.setText("");
                                AppUI.lblTotalHoursDynamic.setText("");
                                AppUI.pnlStartEndDate.setVisible(false);
                                AppUI.pnlGraph.removeAll();
                                AppUI.pnlGraph.revalidate();
                                AppUI.pnlGraph.repaint();
                            } else if (MainMenuUI.appUI instanceof LegacyUI) {
                                Window[] progWindows;
                                for (Window window : progWindows = Window.getWindows()) {
                                    if (!window.getClass().toString().contains("MainMenu.CreateGraph")) continue;
                                    window.dispose();
                                }
                            }
                            AppUI.lblFinalAvg.setText("");
                            AppUI.lblLoadedFileName.setText("");
                            AppUI.lblLoadedFile.setVisible(false);
                        }
                    });
                }
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AppUI.lblLoadedFile.setVisible(true);
                    AppUI.lblLoadedFileName.setText(inputFile.getName());
                    AppUI.strLoadedFilePath = inputFile.getAbsolutePath();
                    AppUI.strLoadedFileName = File.separator + inputFile.getName();
                    Logging.main("File loaded: " + inputFile.getName());
                    AppUI.isFileLoaded = true;
                    AppUI.txtCustomerInfo.setText(strCustomerInfo);
                    AppUI.txtTestSiteInfo.setText(strTestSiteInfo);
                    AppUI.txtLocation.setText(strLocation);
                    AppUI.txtMainDeployedBy.setText(strDeployedBy);
                    AppUI.txtMainRetrievedBy.setText(strRetrievedBy);
                    AppUI.txtMainAnalyzedBy.setText(strAnalyzedBy);
                    AppUI.txtMainWeather.setText(strReportWeather);
                    AppUI.txtMainMitigation.setText(strReportMitigation);
                    AppUI.txtMainComment.setText(strReportComment);
                    AppUI.txtMainProtocol.setText(strReportProtocol);
                    AppUI.txtMainTampering.setText(strReportTampering);
                    AppUI.lblSystemConsole.setText("File successfully loaded.");
                    AppUI.btnGeneratePDF.setVisible(true);
                    AppUI.btnMainImages.setVisible(true);
                    MainMenuUI.appUI.btnExport.setVisible(true);
                    if (MainMenuUI.appUI instanceof MainMenuUI) {
                        MainMenuUI.appUI.btnTestDetails.setVisible(true);
                        AppUI.btnCloseFile.setVisible(true);
                    }
                    AppUI.rewriteDataFile = false;
                }
            });
        }
        catch (FileNotFoundException ex) {
            Logging.main("ERROR: Unable to find the requested Recon data file in LoadSavedFile.java!");
            Logger.getLogger(LoadSavedFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logging.main("ERROR: Fundamental IO Error encountered when parsing Recon data file.");
            Logger.getLogger(LoadSavedFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String getReconSerialFromFileName() {
        if (AppUI.lblLoadedFileName.getText().length() > 0) {
            String[] str_Parsed = AppUI.lblLoadedFileName.getText().split("_");
            if (str_Parsed.length > 2) {
                return str_Parsed[1].trim();
            }
            return "Unknown";
        }
        return "Unknown";
    }

    public static String getReconSerialFromFileName(String fileName) {
        if (fileName.contains("Recon_")) {
            String[] str_Parsed = fileName.split("_");
            if (str_Parsed.length > 1) {
                return str_Parsed[1].trim();
            }
            return "Unknown";
        }
        return "Unknown";
    }

    public static boolean RecoveryNecessary() {
        boolean serialNumberFound = false;
        boolean calDateFound = false;
        boolean cfsFound = false;
        boolean bracketed = false;
        for (int i = 0; i < fileBuffer.size(); ++i) {
            String currentLine = fileBuffer.get(i);
            if (currentLine.contains("Instrument Serial")) {
                serialNumberFound = true;
            }
            if (currentLine.contains("Calibration")) {
                calDateFound = true;
            }
            if (currentLine.contains("CF")) {
                cfsFound = true;
            }
            if (!currentLine.contains("[")) continue;
            bracketed = true;
        }
        return !serialNumberFound || !calDateFound || !cfsFound || !bracketed;
    }

    public static LinkedList<String> parseDataJSON(LinkedList<String> buf) {
        LinkedList<String> result = new LinkedList<String>();
        ListIterator<String> inputItr = buf.listIterator(0);
        StringBuilder sb = new StringBuilder();
        String strAllData = null;
        try {
            while (inputItr.hasNext()) {
                sb.append(inputItr.next());
            }
            strAllData = sb.toString().trim();
            if (!strAllData.startsWith("[")) {
                strAllData = "[" + strAllData;
            }
            if (!strAllData.endsWith("]")) {
                strAllData = strAllData + "]";
            }
            JSONArray arrAllDatafileObjects = (JSONArray)JSONValue.parseWithException(strAllData);
            for (JSONObject tempObj : arrAllDatafileObjects) {
                JSONArray arrAllSubObj;
                if (tempObj.containsKey("DataSamples")) {
                    arrAllSubObj = (JSONArray)JSONValue.parseWithException(tempObj.get("DataSamples").toString());
                    Iterator jsonArrSubIter = arrAllSubObj.iterator();
                    int dataCounter = 0;
                    while (jsonArrSubIter.hasNext()) {
                        JSONObject tempSubObj = (JSONObject)jsonArrSubIter.next();
                        result.add(tempSubObj.get(Integer.toString(dataCounter)).toString().replaceAll(":", ","));
                        ++dataCounter;
                    }
                }
                if (!tempObj.containsKey("TestDetails")) continue;
                arrAllSubObj = (JSONArray)JSONValue.parseWithException(tempObj.get("TestDetails").toString());
                for (JSONObject tempSubObj : arrAllSubObj) {
                    if (tempSubObj.containsKey("RDTVersion")) {
                        strRDTVersion = tempSubObj.get("RDTVersion").toString();
                    }
                    if (tempSubObj.containsKey("InstrumentSerial")) {
                        strInstrumentSerial = tempSubObj.get("InstrumentSerial").toString();
                    }
                    if (tempSubObj.containsKey("CalDate")) {
                        strCalDate = tempSubObj.get("CalDate").toString().trim();
                    }
                    if (tempSubObj.containsKey("FirmwareVersion")) {
                        strFirmwareVersion = tempSubObj.get("FirmwareVersion").toString();
                    }
                    if (tempSubObj.containsKey("Chamber1CF")) {
                        String strEvalCF1 = tempSubObj.get("Chamber1CF").toString();
                        if (strEvalCF1.contains(".")) {
                            strEvalCF1 = new String(strEvalCF1.replace(".", ""));
                        }
                        if (strEvalCF1.contains(",")) {
                            strEvalCF1 = new String(strEvalCF1.replace(",", ""));
                        }
                        LoadedReconCF1 = Double.parseDouble(strEvalCF1) / 1000.0;
                    }
                    if (tempSubObj.containsKey("Chamber2CF")) {
                        String strEvalCF2 = tempSubObj.get("Chamber2CF").toString();
                        if (strEvalCF2.contains(".")) {
                            strEvalCF2 = new String(strEvalCF2.replace(".", ""));
                        }
                        if (strEvalCF2.contains(",")) {
                            strEvalCF2 = new String(strEvalCF2.replace(",", ""));
                        }
                        LoadedReconCF2 = Double.parseDouble(strEvalCF2) / 1000.0;
                    }
                    if (tempSubObj.containsKey("CustomerInformation")) {
                        strCustomerInfo = tempSubObj.get("CustomerInformation").toString();
                    }
                    if (tempSubObj.containsKey("TestSiteInformation")) {
                        strTestSiteInfo = tempSubObj.get("TestSiteInformation").toString();
                    }
                    if (tempSubObj.containsKey("StartDateTime")) {
                        strStartDate = tempSubObj.get("StartDateTime").toString();
                    }
                    if (tempSubObj.containsKey("EndDateTime")) {
                        strEndDate = tempSubObj.get("EndDateTime").toString();
                    }
                    if (tempSubObj.containsKey("Protocol")) {
                        strReportProtocol = tempSubObj.get("Protocol").toString();
                    }
                    if (tempSubObj.containsKey("Tampering")) {
                        strReportTampering = tempSubObj.get("Tampering").toString();
                    }
                    if (tempSubObj.containsKey("Weather")) {
                        strReportWeather = tempSubObj.get("Weather").toString();
                    }
                    if (tempSubObj.containsKey("Mitigation")) {
                        strReportMitigation = tempSubObj.get("Mitigation").toString();
                    }
                    if (tempSubObj.containsKey("Comment")) {
                        strReportComment = tempSubObj.get("Comment").toString();
                    }
                    if (tempSubObj.containsKey("Location")) {
                        strLocation = tempSubObj.get("Location").toString();
                    }
                    if (tempSubObj.containsKey("DeployedBy")) {
                        strDeployedBy = tempSubObj.get("DeployedBy").toString();
                    }
                    if (tempSubObj.containsKey("RetrievedBy")) {
                        strRetrievedBy = tempSubObj.get("RetrievedBy").toString();
                    }
                    if (!tempSubObj.containsKey("AnalyzedBy")) continue;
                    strAnalyzedBy = tempSubObj.get("AnalyzedBy").toString();
                }
            }
            if (result.get(0).contains("CRM")) {
                dataType = DataType.RECON;
                Logging.main("LoadSavedFile: Loading Recon data...");
            } else if (result.get(0).contains("=DN")) {
                dataType = DataType.ANYTM;
                Logging.main("LoadSavedFile: Loading Tamper Monitor data...");
            } else {
                dataType = DataType.UNKNOWN;
                Logging.main("LoadSavedFile: Loading mystery json file (missing identifying information)...");
            }
        }
        catch (ParseException pEx) {
            System.out.println("ERROR: ParseException in parseDataJSON()!");
            pEx.printStackTrace();
        }
        catch (Exception anyEx) {
            System.out.println("ERROR: Exception in parseDataJSON()!");
            anyEx.printStackTrace();
        }
        return result;
    }

    private static void ArchiveImportedFile(File importedFile) {
        File archivedDir = new File(InitDirs.dataDir + File.separator + "archived");
        int extensionIndex = importedFile.getName().lastIndexOf(".");
        Logging.main("Archiving " + importedFile.getName() + " as " + importedFile.getName().substring(0, extensionIndex) + ".zip.");
        try {
            int fileLength;
            if (!archivedDir.exists()) {
                archivedDir.mkdirs();
            }
            FileOutputStream fOut = new FileOutputStream(archivedDir.getAbsolutePath() + File.separator + importedFile.getName().substring(0, extensionIndex) + ".zip");
            ZipOutputStream zipOut = new ZipOutputStream(fOut);
            FileInputStream fIn = new FileInputStream(importedFile);
            ZipEntry zipEntry = new ZipEntry(importedFile.getName());
            zipOut.putNextEntry(zipEntry);
            byte[] data = new byte[1024];
            while ((fileLength = fIn.read(data)) >= 0) {
                zipOut.write(data, 0, fileLength);
            }
            zipOut.close();
            fIn.close();
            fOut.close();
            if (importedFile.getCanonicalPath().contains(InitDirs.dataDir.getCanonicalPath() + File.separator)) {
                importedFile.delete();
            }
        }
        catch (FileNotFoundException fnfEx) {
            Logging.main("FileNotFoundException in LoadSavedFile.ArchiveImportedFile(String)!");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            fnfEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
        catch (IOException ioEx) {
            Logging.main("IOException in LoadSavedFile.ArchiveImportedFile(String)!");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ioEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ProcessBuffer(LinkedList<String> activeBuf) {
        ArrayList<String> arrLine = new ArrayList<String>();
        ArrayList arrLine_temp = new ArrayList();
        boolean testSiteFlag = false;
        boolean customerInfoFlag = false;
        boolean originalFirst4HoursSetting = AppUI.excludeFirst4Hours;
        int i = 0;
        try {
            LoadedReconDataFile.clear();
            for (int counter = 0; counter < activeBuf.size(); ++counter) {
                String[] strLine_parsed;
                String strLine = activeBuf.get(counter);
                if (strLine.length() <= 0) continue;
                if (strLine.contains("=DB") || strLine.contains("=DN")) {
                    if (strLine.contains("[")) {
                        strLine = strLine.replace("[", "");
                    }
                    if (strLine.contains("]")) {
                        strLine = strLine.replace("]", "");
                    }
                    if ((strLine_parsed = strLine.split(","))[0].equals("=DB") || strLine_parsed[0].equals("=DN")) {
                        if ((strLine_parsed[2].equals("H") || strLine_parsed[2].equals("Z")) && strLine_parsed[14].equals("6")) {
                            longTermMode = true;
                            Logging.main("LoadSavedFile: file contains LONG TERM test data.");
                        }
                        if (strLine_parsed[2].equals("S") || strLine_parsed[2].equals("1")) {
                            switch (dataType) {
                                case RECON: {
                                    AppUI.SetStartEndDateStrings("start", strLine_parsed[4], strLine_parsed[5], strLine_parsed[3], strLine_parsed[6], strLine_parsed[7]);
                                    break;
                                }
                                case ANYTM: {
                                    AppUI.SetStartEndDateStrings("start", strLine_parsed[5], strLine_parsed[6], strLine_parsed[4], strLine_parsed[7], strLine_parsed[8]);
                                    break;
                                }
                            }
                        }
                        if (strLine_parsed[2].equals("E") || strLine_parsed[2].equals("2")) {
                            switch (dataType) {
                                case RECON: {
                                    AppUI.SetStartEndDateStrings("end", strLine_parsed[4], strLine_parsed[5], strLine_parsed[3], strLine_parsed[6], strLine_parsed[7]);
                                    break;
                                }
                                case ANYTM: {
                                    AppUI.SetStartEndDateStrings("end", strLine_parsed[5], strLine_parsed[6], strLine_parsed[4], strLine_parsed[7], strLine_parsed[8]);
                                    break;
                                }
                            }
                        }
                        for (int arrayCounter = 0; arrayCounter <= strLine_parsed.length - 1; ++arrayCounter) {
                            arrLine.add(arrayCounter, strLine_parsed[arrayCounter].trim());
                        }
                        arrLine_temp = (ArrayList)arrLine.clone();
                        LoadedReconDataFile.add(arrLine_temp);
                        Logging.main(Arrays.toString(LoadedReconDataFile.get(i).toArray()));
                        Logging.main("Adding record #" + LoadedReconDataFile.get(i).get(1) + " to ArrayList, whose new size is now " + LoadedReconDataFile.size() + ".");
                        arrLine.clear();
                        Logging.main("Checking Status: " + Arrays.toString(LoadedReconDataFile.get(i).toArray()));
                        ++i;
                    }
                }
                if (!isFileCSVText) continue;
                if (strLine.contains("Instrument Serial: ")) {
                    strLine_parsed = strLine.split(" ");
                    strInstrumentSerial = strLine_parsed[2];
                    Logging.main("Serial# found and parsed: " + strInstrumentSerial);
                }
                if (strLine.contains("Chamber 1 CF: ")) {
                    strLine_parsed = strLine.split(" ");
                    LoadedReconCF1 = Double.parseDouble(strLine_parsed[3]);
                    Logging.main("CF1 found and parsed: " + LoadedReconCF1);
                }
                if (strLine.contains("Chamber 2 CF: ")) {
                    strLine_parsed = strLine.split(" ");
                    LoadedReconCF2 = Double.parseDouble(strLine_parsed[3]);
                    Logging.main("CF2 found and parsed: " + LoadedReconCF2);
                }
                if (strLine.contains("Start Date/Time:")) {
                    strLine_parsed = strLine.split(" ");
                    strStartDate = strLine_parsed[2] + " " + strLine_parsed[3];
                }
                if (strLine.contains("End Date/Time:")) {
                    strLine_parsed = strLine.split(" ");
                    strEndDate = strLine_parsed[2] + " " + strLine_parsed[3];
                }
                if (strLine.contains("Deployed By:")) {
                    strDeployedBy = strLine.substring(12);
                }
                if (strLine.contains("Retrieved By:")) {
                    strRetrievedBy = strLine.substring(13);
                }
                if (strLine.contains("Analyzed By:")) {
                    strAnalyzedBy = strLine.substring(12);
                }
                if (strLine.contains("Calibration Date =")) {
                    strLine_parsed = strLine.split("=");
                    strCalDate = strLine_parsed[1].trim();
                }
                if (strLine.length() > 8 && strLine.substring(0, 9).contains("Protocol:")) {
                    strReportProtocol = strLine.substring(9).trim();
                } else if (strLine.length() > 9 && strLine.substring(0, 10).contains("Tampering:")) {
                    strReportTampering = strLine.substring(10).trim();
                } else if (strLine.length() > 7 && strLine.substring(0, 8).contains("Weather:")) {
                    strReportWeather = strLine.substring(8).trim();
                } else if (strLine.length() > 10 && strLine.substring(0, 11).contains("Mitigation:")) {
                    strReportMitigation = strLine.substring(11).trim();
                } else if (strLine.length() > 7 && strLine.substring(0, 8).contains("Comment:")) {
                    strReportComment = strLine.substring(8).trim();
                }
                if (testSiteFlag) {
                    if (strLine.contains("Instrument Serial:") || strLine.contains("SUMMARY:")) {
                        testSiteFlag = false;
                        if (strTestSiteInfo.length() > 1) {
                            strTestSiteInfo = strTestSiteInfo.trim();
                            Logging.main("Test Site Info: " + strTestSiteInfo);
                        } else {
                            Logging.main("Unable to find any Test Site Info in " + AppUI.lblLoadedFileName.getText() + "!");
                        }
                    } else {
                        strTestSiteInfo = strTestSiteInfo + "\n" + strLine;
                    }
                }
                if (strLine.contains("Test site information:")) {
                    testSiteFlag = true;
                }
                if (customerInfoFlag) {
                    if (strLine.contains("Test site information:")) {
                        customerInfoFlag = false;
                        if (strCustomerInfo.length() > 1) {
                            strCustomerInfo = strCustomerInfo.trim();
                            Logging.main("Customer Info: " + strCustomerInfo);
                        } else {
                            Logging.main("Unable to find any Customer Info in " + AppUI.lblLoadedFileName.getText() + "!");
                        }
                    } else {
                        strCustomerInfo = strCustomerInfo + "\n" + strLine;
                    }
                }
                if (strLine.contains("Customer information:")) {
                    customerInfoFlag = true;
                }
                if (!strLine.contains("Location:") || strLine.length() <= 11) continue;
                strLocation = strLine;
                strLocation = strLocation.trim();
                strLocation = strLocation.substring(10);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainMenuUI.appUI.RefreshStartEndDateLabels();
                }
            });
            if (dataRangePresent && rangeAverageFirstFourHours) {
                AppUI.excludeFirst4Hours = false;
            } else if (dataRangePresent && !rangeAverageFirstFourHours) {
                AppUI.excludeFirst4Hours = true;
            }
            String[] test_args = new String[]{"Radon Concentration", strOpenFileName};
            CreateGraph.photodiodeFailure_Ch1 = false;
            CreateGraph.photodiodeFailure_Ch2 = false;
            CreateGraph.main(test_args);
        }
        catch (Exception anyEx) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
        finally {
            AppUI.excludeFirst4Hours = originalFirst4HoursSetting;
        }
    }

    public static void LoadRangeBuffer() {
        boolean addingToBuffer = false;
        for (int i = 0; i < fileBuffer.size(); ++i) {
            String currentLine = fileBuffer.get(i);
            if (!currentLine.contains("=DB")) continue;
            CharSequence[] currentLine_parsed = currentLine.split(",");
            if (addingToBuffer) {
                rangeBuffer.add(currentLine);
            }
            if (currentLine_parsed[1].equals(userRangeStartAddress)) {
                currentLine_parsed[2] = "S";
                rangeBuffer.add(String.join((CharSequence)",", currentLine_parsed));
                addingToBuffer = true;
                strStartDate = (String)currentLine_parsed[4] + "-" + (String)currentLine_parsed[5] + "-20" + (String)currentLine_parsed[3] + " " + (String)currentLine_parsed[6] + ":" + (String)currentLine_parsed[7];
                continue;
            }
            if (!currentLine_parsed[1].equals(userRangeEndAddress)) continue;
            currentLine_parsed[2] = "E";
            rangeBuffer.add(String.join((CharSequence)",", currentLine_parsed));
            strEndDate = (String)currentLine_parsed[4] + "-" + (String)currentLine_parsed[5] + "-20" + (String)currentLine_parsed[3] + " " + (String)currentLine_parsed[6] + ":" + (String)currentLine_parsed[7];
            break;
        }
    }

    static enum DataType {
        RECON,
        ANYTM,
        UNKNOWN;

    }
}

