/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.Logging;
import MainMenu.WriteCommTimeout;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jssc.SerialPort;
import jssc.SerialPortException;

public class WriteComm {
    public static void main(SerialPort commPort, String input) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Boolean> writeResult = executorService.submit(new WriteCommTimeout(commPort, input));
        boolean success = false;
        SerialPort serialPort = commPort;
        try {
            success = writeResult.get(2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            if (serialPort.isOpened()) {
                try {
                    Logging.main("Attempting to close non-responsive port on " + serialPort.getPortName() + "...");
                    serialPort.closePort();
                }
                catch (SerialPortException exSerialPort) {
                    Logging.main("Unable to close serial port on " + serialPort.getPortName() + " after timeout.");
                }
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
        if (!success) {
            Logging.main("Timeout from comm port on " + serialPort.getPortName() + "!");
        }
        executorService.shutdown();
    }
}

