/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.AppUI;
import MainMenu.InitDirs;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import MainMenu.ReadComm;
import MainMenu.ScanComm;
import MainMenu.WriteComm;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.regex.Pattern;

class TMProtocol {
    public static String instrumentSerial = "not set";
    public static String firmwareVersion = "not set";
    public static String filenameJSON;
    public static String defaultFilename;
    public static String DeviceResponse;
    public static String[] DeviceResponse_parsed;
    public static LinkedList<String[]> tmSession;
    public static LinkedList<Integer> sessionAddresses;
    public static String strStartDateTime;
    public static String strEndDateTime;
    public static String[] pointerTable_raw;
    public static int currentSession;
    public static boolean hasCN;

    TMProtocol() {
    }

    public static void LoadFirstRecord() {
        WriteComm.main(ScanComm.scannedPort, ":RB\n");
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
    }

    public static void LoadNextRecord() {
        WriteComm.main(ScanComm.scannedPort, ":RN\n");
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
    }

    public static void LoadSpecifiedRecord(String number) {
        WriteComm.main(ScanComm.scannedPort, ":RN" + number + "\n");
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
    }

    public static void LoadSpecifiedRecord(int number) {
        WriteComm.main(ScanComm.scannedPort, ":RN" + Integer.toString(number) + "\n");
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
    }

    public static void SetTMID() {
        WriteComm.main(ScanComm.scannedPort, ":RS\n");
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse_parsed = DeviceResponse.split(",");
        instrumentSerial = DeviceResponse_parsed[1].trim();
        WriteComm.main(ScanComm.scannedPort, ":RV\n");
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse_parsed = DeviceResponse.split(",");
        firmwareVersion = DeviceResponse_parsed[2].trim();
        hasCN = !(Double.parseDouble(firmwareVersion) < 4.08);
    }

    public static void SetTMTimeFromPC() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yy,MM,dd,HH,mm,ss");
        LocalDateTime currentTime = LocalDateTime.now();
        String strCurrentTime = currentTime.format(formatter);
        Logging.main("Issuing :WT instruction to write time...");
        WriteComm.main(ScanComm.scannedPort, ":WT" + strCurrentTime + "\n");
    }

    public static void GetPointerTable() {
        pointerTable_raw = new String[16];
        sessionAddresses.clear();
        WriteComm.main(ScanComm.scannedPort, ":CN\n");
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
        String oldestSessionString = DeviceResponse_parsed[1];
        oldestSessionString = oldestSessionString.trim();
        int oldestSession = Integer.parseInt(oldestSessionString);
        int numSessions = MainMenuUI.appUI.getDataSessions();
        int rawAddressIndex = 0;
        for (int i = 0; i < 19; ++i) {
            if (i < 3) continue;
            TMProtocol.pointerTable_raw[rawAddressIndex] = DeviceResponse_parsed[i];
            ++rawAddressIndex;
        }
        rawAddressIndex = oldestSession;
        for (int j = 0; j < numSessions; ++j) {
            if (rawAddressIndex == 16) {
                rawAddressIndex = 0;
            }
            String tempString = pointerTable_raw[rawAddressIndex];
            tempString = tempString.trim();
            sessionAddresses.add(Integer.parseInt(tempString));
            ++rawAddressIndex;
        }
    }

    public static String GetSessionDescription(int sessionStartPoint) {
        String description;
        int numDataRecords = 6143;
        if (sessionStartPoint < numDataRecords) {
            TMProtocol.LoadSpecifiedRecord(sessionStartPoint);
        } else {
            TMProtocol.LoadSpecifiedRecord(0);
        }
        if (DeviceResponse_parsed.length > 1) {
            if (DeviceResponse_parsed[2].contains("1")) {
                description = DeviceResponse_parsed[5] + "/" + DeviceResponse_parsed[6] + "/" + DeviceResponse_parsed[4] + " @ " + DeviceResponse_parsed[7] + ":" + DeviceResponse_parsed[8];
            } else {
                Logging.main("Read bad value when attempting to get session description string (arm date). Skipping...");
                description = "null";
            }
        } else {
            Logging.main("Read bad value when attempting to get session description string (arm date). Skipping...");
            description = "null";
        }
        return description;
    }

    public static void ClearDownloadFlag() {
        switch (MainMenuUI.appUI.deviceType) {
            case TM: {
                WriteComm.main(ScanComm.scannedPort, ":CM\n");
                Logging.main("Tamper Monitor can now be rearmed!");
                break;
            }
            case MTM: {
                WriteComm.main(ScanComm.scannedPort, ":CM\n");
                Logging.main("Tamper Monitor can now be rearmed!");
                break;
            }
            case MTM2: {
                WriteComm.main(ScanComm.scannedPort, ":CD\n");
                Logging.main("Mini TM II session cleared!");
                break;
            }
        }
    }

    public static void SetDefaultFilename(int sessionIndex) {
        switch (MainMenuUI.appUI.deviceType) {
            case TM: {
                TMProtocol.LoadSpecifiedRecord(sessionIndex);
                defaultFilename = "TM_" + instrumentSerial + "_" + DeviceResponse_parsed[5] + DeviceResponse_parsed[6] + DeviceResponse_parsed[4];
                break;
            }
            case MTM: {
                TMProtocol.LoadSpecifiedRecord(sessionIndex);
                defaultFilename = "MiniTM_" + instrumentSerial + "_" + DeviceResponse_parsed[5] + DeviceResponse_parsed[6] + DeviceResponse_parsed[4];
                break;
            }
            case MTM2: {
                if (hasCN) {
                    TMProtocol.LoadSpecifiedRecord(sessionIndex);
                } else {
                    WriteComm.main(ScanComm.scannedPort, ":RB\n");
                    DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
                    if (DeviceResponse.contains("=DN")) {
                        DeviceResponse_parsed = DeviceResponse.split(",");
                        TMProtocol.LoadSpecifiedRecord(DeviceResponse_parsed[1]);
                        currentSession = Integer.parseInt(DeviceResponse_parsed[1]);
                    } else {
                        Logging.main("Error getting Mini TM-II start address!");
                        return;
                    }
                }
                defaultFilename = "MiniTM-II_" + instrumentSerial + "_" + DeviceResponse_parsed[5] + DeviceResponse_parsed[6] + DeviceResponse_parsed[4];
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void DetermineFileName() {
        JSON_name = null;
        JSON_exists = false;
        JSON_file = null;
        acceptableFilenameChars = Pattern.compile("[a-zA-Z0-9\\-\\_\\.\\s\\,]*");
        testSiteArray = AppUI.txtTestSiteInfo.getText().split("\\r?\\n");
        testSite = testSiteArray[0];
        testSite = testSite.replaceAll("[\\n\\r+]", "");
        if (!MainMenuUI.appUI.chkUseStreetAddressForFilename.isSelected()) ** GOTO lbl-1000
        if (AppUI.txtTestSiteInfo.getText().length() > 0) {
            patternMatcher = acceptableFilenameChars.matcher(testSite);
            if (!patternMatcher.matches()) {
                MainMenuUI.appUI.invalidFilename = true;
                JSON_name = InitDirs.dataDir + File.separator + TMProtocol.defaultFilename + ".json";
            } else {
                while (testSite.endsWith(".") || testSite.endsWith(" ")) {
                    testSite = testSite.substring(0, testSite.length() - 1);
                }
                JSON_name = InitDirs.dataDir + File.separator + testSite + ".json";
                MainMenuUI.appUI.invalidFilename = false;
            }
        } else if (!(patternMatcher = acceptableFilenameChars.matcher(MainMenuUI.appUI.txtNewFileName.getText())).matches()) {
            MainMenuUI.appUI.invalidFilename = true;
            JSON_name = InitDirs.dataDir + File.separator + TMProtocol.defaultFilename + ".json";
        } else if (MainMenuUI.appUI.txtNewFileName.getText().length() > 0) {
            while (MainMenuUI.appUI.txtNewFileName.getText().endsWith(".") || MainMenuUI.appUI.txtNewFileName.getText().endsWith(" ")) {
                MainMenuUI.appUI.txtNewFileName.setText(MainMenuUI.appUI.txtNewFileName.getText().substring(0, MainMenuUI.appUI.txtNewFileName.getText().length() - 1));
            }
            JSON_name = InitDirs.dataDir + File.separator + MainMenuUI.appUI.txtNewFileName.getText() + ".json";
            MainMenuUI.appUI.invalidFilename = false;
        } else {
            JSON_name = InitDirs.dataDir + File.separator + TMProtocol.defaultFilename + ".json";
            MainMenuUI.appUI.invalidFilename = false;
        }
        TMProtocol.filenameJSON = new String(JSON_name);
    }

    public static boolean DownloadTMSessionToRAM() throws InterruptedException {
        int numDataRecords = 6043;
        int recordIterator = 0;
        switch (MainMenuUI.appUI.deviceType) {
            case TM: {
                TMProtocol.LoadFirstRecord();
                recordIterator = 0;
                break;
            }
            case MTM: {
                TMProtocol.LoadFirstRecord();
                recordIterator = 0;
                break;
            }
            case MTM2: {
                if (hasCN) {
                    TMProtocol.LoadSpecifiedRecord(sessionAddresses.get(currentSession));
                    recordIterator = Integer.parseInt(DeviceResponse_parsed[1]);
                    break;
                }
                TMProtocol.LoadSpecifiedRecord(currentSession);
                recordIterator = currentSession;
                break;
            }
        }
        DateTimeFormatter DateTimeDisplay = DateTimeFormatter.ofPattern("MM-dd-yyyy HH:mm");
        int numReReadAttempts = 1;
        int maxNumReReadAttempts = 5;
        if (tmSession != null) {
            tmSession.clear();
        } else {
            tmSession = new LinkedList();
        }
        if (DeviceResponse_parsed.length == 1) {
            Logging.main("Session pointer pointing to null record. Aborting download.");
            return false;
        }
        int baseYear = 2000 + Integer.parseInt(DeviceResponse_parsed[4]);
        LocalDateTime startDateTime = LocalDateTime.of(baseYear, Integer.parseInt(DeviceResponse_parsed[5]), Integer.parseInt(DeviceResponse_parsed[6]), Integer.parseInt(DeviceResponse_parsed[7]), Integer.parseInt(DeviceResponse_parsed[8]), Integer.parseInt(DeviceResponse_parsed[9]));
        strStartDateTime = DateTimeDisplay.format(startDateTime);
        tmSession.add(DeviceResponse_parsed);
        while (!DeviceResponse_parsed[2].equals("2")) {
            if (++recordIterator > numDataRecords) {
                recordIterator = -1;
                continue;
            }
            TMProtocol.LoadNextRecord();
            if (DeviceResponse_parsed.length == 1) {
                Logging.main("Null record found in session. Skipping.");
                continue;
            }
            MainMenuUI.appUI.displayProgressLabel("Reading Record #" + DeviceResponse_parsed[1] + "...");
            if (DeviceResponse_parsed[2].equals("2")) {
                baseYear = 2000 + Integer.parseInt(DeviceResponse_parsed[4]);
                LocalDateTime endDateTime = LocalDateTime.of(baseYear, Integer.parseInt(DeviceResponse_parsed[5]), Integer.parseInt(DeviceResponse_parsed[6]), Integer.parseInt(DeviceResponse_parsed[7]), Integer.parseInt(DeviceResponse_parsed[8]), Integer.parseInt(DeviceResponse_parsed[9]));
                strEndDateTime = DateTimeDisplay.format(endDateTime);
            }
            if (recordIterator != Integer.parseInt(DeviceResponse_parsed[1])) {
                while (recordIterator != Integer.parseInt(DeviceResponse_parsed[1]) || numReReadAttempts <= 5) {
                    Logging.main("Re-reading sample #" + Integer.toString(recordIterator));
                    TMProtocol.LoadSpecifiedRecord(Integer.toString(recordIterator));
                    if (recordIterator == Integer.parseInt(DeviceResponse_parsed[1])) continue;
                    ++numReReadAttempts;
                }
            }
            tmSession.add(DeviceResponse_parsed);
            if (Integer.parseInt(DeviceResponse_parsed[1]) != numDataRecords) continue;
            recordIterator = -1;
        }
        return true;
    }

    static {
        sessionAddresses = new LinkedList();
        strStartDateTime = "not set";
        strEndDateTime = "not set";
    }
}

