/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.AppUI;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import MainMenu.WriteComm;
import java.util.logging.Level;
import java.util.logging.Logger;
import jssc.SerialPort;
import jssc.SerialPortException;

public class ReadComm {
    public static String main(SerialPort commPort, int byteLength) {
        SerialPort serialPort = commPort;
        int sleepDur = 10;
        switch (MainMenuUI.appUI.deviceType) {
            case RECON: {
                sleepDur = 10;
                break;
            }
            case CWLM: {
                break;
            }
            case NONE: {
                sleepDur = 10;
                break;
            }
            default: {
                sleepDur = 50;
            }
        }
        try {
            Thread.sleep(sleepDur);
            String buffer = serialPort.readString();
            Logging.main(buffer);
            if (buffer == null) {
                buffer = ReadComm.NoResponseHandler(serialPort, byteLength);
            }
            return buffer;
        }
        catch (SerialPortException ex) {
            Logging.main("Serial port exception encountered. Unable to read response from " + serialPort.getPortName());
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ReadComm.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public static String NoResponseHandler(SerialPort commPort, int byteLength) {
        SerialPort serialPort = commPort;
        try {
            Logging.main("No response from " + serialPort.getPortName() + "... let's attempt write last command to this port one more time.");
            Logging.main("Confirm CommPort @ " + serialPort + " / Confirm Byte Length = " + byteLength);
            serialPort.purgePort(8);
            serialPort.purgePort(4);
            serialPort.purgePort(2);
            serialPort.purgePort(1);
            Thread.sleep(100L);
            Logging.main("Attempting to issue the last written command: " + AppUI.lastSentCommand);
            WriteComm.main(serialPort, AppUI.lastSentCommand);
            Thread.sleep(100L);
            String buffer = serialPort.readString();
            Logging.main("Retry response = " + buffer);
            if (buffer == null) {
                Logging.main("Continued null response!");
                Logging.main("Is port still opened? = " + serialPort.isOpened());
            } else {
                Logging.main("Successful response on retry!");
            }
            return buffer;
        }
        catch (SerialPortException ex) {
            Logging.main("Attempted to read again, but received no response from " + serialPort.getPortName() + ".");
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ReadComm.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}

