/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import Config.Config;
import Config.FlagForm;
import MainMenu.AppUI;
import MainMenu.ImageSelectionPanel;
import MainMenu.InitDirs;
import MainMenu.LoadSavedFile;
import MainMenu.Logging;
import MainMenu.ReconProtocol;
import MainMenu.TMProtocol;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class LegacyUI
extends AppUI {
    private JPanel pnlRightButtons;
    private JPanel pnlSelectSession;
    private JPanel pnlSessionInfo;
    private JPanel pnlVersInfo;

    public LegacyUI() {
        File xlsTemplate = new File("ReconTemplate.xls");
        if (!xlsTemplate.exists()) {
            Logging.main("XLS template not present. You will not be able to create XLS files.");
        }
        this.initComponents();
        LegacyUI.InitDeploymentFields();
        lblReconSN.setVisible(false);
        lblFirmwareVersion.setVisible(false);
        lblDataSessions.setVisible(false);
        this.btnClearSession.setVisible(false);
        this.btnClearMemory.setVisible(false);
        this.btnAllDataDump.setVisible(false);
        this.btnDownloadSession.setVisible(false);
        this.btnOpenSavedFile.setVisible(true);
        btnGeneratePDF.setVisible(false);
        this.btnExport.setVisible(false);
        this.btnEraseReconData.setVisible(false);
        lblLoadedFile.setVisible(false);
        lblLoadedFileName.setVisible(false);
        this.btnSyncTime.setVisible(false);
        this.btnClearTamperFlag.setVisible(false);
        btnMainImages.setVisible(false);
        this.btnDisplaySettings.setVisible(false);
        lblVersion.setText(this.version);
        if (countLimiter) {
            this.limiterLabel.setVisible(false);
        }
        this.EnableFileNaming(false);
        cboSessionSelect.setVisible(false);
    }

    public static void InitDeploymentFields() {
        txtCustomerInfo.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtTestSiteInfo.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
        txtLocation.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AppUI.rewriteDataFile = true;
            }
        });
    }

    private void initComponents() {
        this.btnCloseProgram = new JButton();
        this.lblRadonScoutQuickCal = new JLabel();
        lblSystemConsole = new JLabel();
        this.btnConnect = new JButton();
        lblReconSN = new JLabel();
        lblFirmwareVersion = new JLabel();
        lblDataSessions = new JLabel();
        btnConfig = new JButton();
        this.lblTestSiteInfo = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        txtTestSiteInfo = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        txtCustomerInfo = new JTextArea();
        this.lblTestSiteInfo1 = new JLabel();
        this.lblLocation = new JLabel();
        txtLocation = new JTextField();
        this.pnlSelectSession = new JPanel();
        cboSessionSelect = new JComboBox();
        this.txtNewFileName = new JTextField();
        this.chkUseStreetAddressForFilename = new JCheckBox();
        this.pnlSessionInfo = new JPanel();
        lblLoadedFile = new JLabel();
        lblLoadedFileName = new JLabel();
        lblFinalAvg = new JLabel();
        this.pnlRightButtons = new JPanel();
        this.btnAllDataDump = new JButton();
        this.btnOpenSavedFile = new JButton();
        this.btnSyncTime = new JButton();
        this.btnDisplaySettings = new JButton();
        this.btnDownloadSession = new JButton();
        this.btnExport = new JButton();
        this.btnEraseReconData = new JButton();
        btnGeneratePDF = new JButton();
        btnMainImages = new JButton();
        this.btnClearTamperFlag = new JButton();
        this.btnOpenPDF = new JButton();
        this.btnClearMemory = new JButton();
        this.pnlVersInfo = new JPanel();
        this.limiterLabel = new JLabel();
        lblVersion = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Rad Elec Recon Download Tool");
        this.setIconImages(null);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LegacyUI.this.formWindowClosing(evt);
            }
        });
        this.btnCloseProgram.setText("Close");
        this.btnCloseProgram.setBorder(new SoftBevelBorder(0));
        this.btnCloseProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnCloseProgramActionPerformed(evt);
            }
        });
        this.lblRadonScoutQuickCal.setHorizontalAlignment(0);
        this.lblRadonScoutQuickCal.setIcon(new ImageIcon(this.getClass().getResource("/MainMenu/RadElecReconDownloadTool_legacy.png")));
        lblSystemConsole.setFont(new Font("Calibri", 0, 12));
        lblSystemConsole.setHorizontalAlignment(0);
        lblSystemConsole.setText("System Console");
        this.btnConnect.setFont(new Font("Calibri", 1, 24));
        this.btnConnect.setText("Connect");
        this.btnConnect.setToolTipText("Click here to search for the Recon CRM.");
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnConnectActionPerformed(evt);
            }
        });
        lblReconSN.setFont(new Font("Calibri", 0, 12));
        lblReconSN.setText("Recon S/N:");
        lblFirmwareVersion.setFont(new Font("Calibri", 0, 12));
        lblFirmwareVersion.setText("Firmware v");
        lblDataSessions.setFont(new Font("Calibri", 0, 12));
        lblDataSessions.setHorizontalAlignment(0);
        lblDataSessions.setText("Data Sessions:");
        lblDataSessions.setHorizontalTextPosition(0);
        lblDataSessions.setMaximumSize(new Dimension(181, 16));
        lblDataSessions.setMinimumSize(new Dimension(181, 16));
        lblDataSessions.setName("");
        lblDataSessions.setPreferredSize(new Dimension(181, 16));
        btnConfig.setText("Config");
        btnConfig.setBorder(new SoftBevelBorder(0));
        btnConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnConfigActionPerformed(evt);
            }
        });
        this.lblTestSiteInfo.setFont(new Font("Calibri", 1, 14));
        this.lblTestSiteInfo.setText("Test Site Information");
        txtTestSiteInfo.setColumns(20);
        txtTestSiteInfo.setRows(5);
        txtTestSiteInfo.setTabSize(4);
        txtTestSiteInfo.setBorder(null);
        this.jScrollPane1.setViewportView(txtTestSiteInfo);
        txtCustomerInfo.setColumns(20);
        txtCustomerInfo.setRows(5);
        txtCustomerInfo.setTabSize(4);
        txtCustomerInfo.setBorder(null);
        this.jScrollPane2.setViewportView(txtCustomerInfo);
        txtCustomerInfo.getAccessibleContext().setAccessibleName("");
        this.lblTestSiteInfo1.setFont(new Font("Calibri", 1, 14));
        this.lblTestSiteInfo1.setText("Customer Information");
        this.lblLocation.setFont(new Font("Calibri", 1, 14));
        this.lblLocation.setText("Test Location");
        txtLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.txtLocationActionPerformed(evt);
            }
        });
        cboSessionSelect.setFont(new Font("Calibri", 1, 14));
        cboSessionSelect.setToolTipText("Select a data session to download.");
        cboSessionSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.cboSessionSelectActionPerformed(evt);
            }
        });
        this.txtNewFileName.setToolTipText("Enter preferred filename for the downloaded test. Do not include an extension.");
        this.chkUseStreetAddressForFilename.setFont(new Font("Calibri", 1, 14));
        this.chkUseStreetAddressForFilename.setText("Use street address?");
        this.chkUseStreetAddressForFilename.setToolTipText("Check to use the first line of Test Site Information.");
        GroupLayout pnlSelectSessionLayout = new GroupLayout(this.pnlSelectSession);
        this.pnlSelectSession.setLayout(pnlSelectSessionLayout);
        pnlSelectSessionLayout.setHorizontalGroup(pnlSelectSessionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSelectSessionLayout.createSequentialGroup().addContainerGap().addGroup(pnlSelectSessionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSelectSessionLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.chkUseStreetAddressForFilename)).addGroup(pnlSelectSessionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtNewFileName).addComponent(cboSessionSelect, -2, 169, -2))).addContainerGap()));
        pnlSelectSessionLayout.setVerticalGroup(pnlSelectSessionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSelectSessionLayout.createSequentialGroup().addContainerGap().addComponent(cboSessionSelect, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtNewFileName, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkUseStreetAddressForFilename).addContainerGap()));
        lblLoadedFile.setFont(new Font("Calibri", 0, 12));
        lblLoadedFile.setHorizontalAlignment(0);
        lblLoadedFile.setText("Loaded File");
        lblLoadedFile.setHorizontalTextPosition(0);
        lblLoadedFile.setMaximumSize(new Dimension(181, 16));
        lblLoadedFile.setMinimumSize(new Dimension(181, 16));
        lblLoadedFile.setName("");
        lblLoadedFile.setPreferredSize(new Dimension(181, 16));
        lblLoadedFileName.setFont(new Font("Calibri", 1, 12));
        lblLoadedFileName.setHorizontalAlignment(0);
        lblLoadedFileName.setText("No File Loaded");
        lblLoadedFileName.setHorizontalTextPosition(0);
        lblLoadedFileName.setMaximumSize(new Dimension(181, 16));
        lblLoadedFileName.setMinimumSize(new Dimension(181, 16));
        lblLoadedFileName.setName("");
        lblLoadedFileName.setPreferredSize(new Dimension(181, 16));
        lblFinalAvg.setFont(new Font("Calibri", 1, 24));
        GroupLayout pnlSessionInfoLayout = new GroupLayout(this.pnlSessionInfo);
        this.pnlSessionInfo.setLayout(pnlSessionInfoLayout);
        pnlSessionInfoLayout.setHorizontalGroup(pnlSessionInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlSessionInfoLayout.createSequentialGroup().addGap(28, 28, 28).addComponent(lblFinalAvg, -2, 295, -2).addGap(25, 25, 25)).addGroup(pnlSessionInfoLayout.createSequentialGroup().addGap(70, 70, 70).addGroup(pnlSessionInfoLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lblLoadedFile, -2, 181, -2).addComponent(lblLoadedFileName, -2, 181, -2)).addContainerGap()));
        pnlSessionInfoLayout.setVerticalGroup(pnlSessionInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSessionInfoLayout.createSequentialGroup().addContainerGap().addComponent(lblLoadedFile, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblLoadedFileName, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblFinalAvg, -2, 41, -2).addContainerGap(21, Short.MAX_VALUE)));
        this.btnAllDataDump.setFont(new Font("Calibri", 0, 12));
        this.btnAllDataDump.setLabel("All Data Dump");
        this.btnAllDataDump.setMaximumSize(new Dimension(125, 25));
        this.btnAllDataDump.setMinimumSize(new Dimension(125, 25));
        this.btnAllDataDump.setPreferredSize(new Dimension(125, 25));
        this.btnAllDataDump.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnAllDataDumpActionPerformed(evt);
            }
        });
        this.btnOpenSavedFile.setFont(new Font("Calibri", 0, 12));
        this.btnOpenSavedFile.setText("Open Saved File");
        this.btnOpenSavedFile.setToolTipText("Open previously downloaded data file.");
        this.btnOpenSavedFile.setMaximumSize(new Dimension(125, 25));
        this.btnOpenSavedFile.setMinimumSize(new Dimension(125, 25));
        this.btnOpenSavedFile.setName("");
        this.btnOpenSavedFile.setPreferredSize(new Dimension(125, 25));
        this.btnOpenSavedFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnOpenSavedFileActionPerformed(evt);
            }
        });
        this.btnSyncTime.setFont(new Font("Calibri", 0, 12));
        this.btnSyncTime.setToolTipText("Sync Recon time to PC time. Must have Recon connected.");
        this.btnSyncTime.setLabel("Sync Time");
        this.btnSyncTime.setMaximumSize(new Dimension(125, 25));
        this.btnSyncTime.setMinimumSize(new Dimension(125, 25));
        this.btnSyncTime.setPreferredSize(new Dimension(125, 25));
        this.btnSyncTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnSyncTimeActionPerformed(evt);
            }
        });
        this.btnDisplaySettings.setFont(new Font("Calibri", 0, 12));
        this.btnDisplaySettings.setText("Display Settings");
        this.btnDisplaySettings.setMaximumSize(new Dimension(125, 25));
        this.btnDisplaySettings.setMinimumSize(new Dimension(125, 25));
        this.btnDisplaySettings.setPreferredSize(new Dimension(125, 25));
        this.btnDisplaySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnDisplaySettingsActionPerformed(evt);
            }
        });
        this.btnDownloadSession.setFont(new Font("Calibri", 0, 12));
        this.btnDownloadSession.setText("Download Session");
        this.btnDownloadSession.setToolTipText("Download current session from Recon.");
        this.btnDownloadSession.setMaximumSize(new Dimension(125, 25));
        this.btnDownloadSession.setMinimumSize(new Dimension(125, 25));
        this.btnDownloadSession.setPreferredSize(new Dimension(125, 25));
        this.btnDownloadSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnDownloadSessionActionPerformed(evt);
            }
        });
        this.btnExport.setFont(new Font("Calibri", 0, 12));
        this.btnExport.setText("Export");
        this.btnExport.setToolTipText("Export open radon test to other formats.");
        this.btnExport.setMaximumSize(new Dimension(125, 25));
        this.btnExport.setMinimumSize(new Dimension(125, 25));
        this.btnExport.setPreferredSize(new Dimension(125, 25));
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnExportActionPerformed(evt);
            }
        });
        this.btnEraseReconData.setFont(new Font("Calibri", 0, 12));
        this.btnEraseReconData.setText("Clear Session");
        this.btnEraseReconData.setToolTipText("Clears current data session from Recon.");
        this.btnEraseReconData.setMaximumSize(new Dimension(125, 25));
        this.btnEraseReconData.setMinimumSize(new Dimension(125, 25));
        this.btnEraseReconData.setPreferredSize(new Dimension(125, 25));
        this.btnEraseReconData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnEraseReconDataActionPerformed(evt);
            }
        });
        btnGeneratePDF.setFont(new Font("Calibri", 0, 12));
        btnGeneratePDF.setToolTipText("Generate PDF from current results.");
        btnGeneratePDF.setLabel("Generate PDF");
        btnGeneratePDF.setMaximumSize(new Dimension(125, 25));
        btnGeneratePDF.setMinimumSize(new Dimension(125, 25));
        btnGeneratePDF.setName("");
        btnGeneratePDF.setPreferredSize(new Dimension(125, 25));
        btnGeneratePDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnGeneratePDFActionPerformed(evt);
            }
        });
        btnMainImages.setFont(new Font("Calibri", 0, 12));
        btnMainImages.setText("Report Images");
        btnMainImages.setToolTipText("Select images to add to report.");
        btnMainImages.setMaximumSize(new Dimension(125, 25));
        btnMainImages.setMinimumSize(new Dimension(125, 25));
        btnMainImages.setPreferredSize(new Dimension(125, 25));
        btnMainImages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnMainImagesActionPerformed(evt);
            }
        });
        this.btnClearTamperFlag.setFont(new Font("Calibri", 0, 12));
        this.btnClearTamperFlag.setText("Clear Tamper Flag");
        this.btnClearTamperFlag.setMaximumSize(new Dimension(125, 25));
        this.btnClearTamperFlag.setMinimumSize(new Dimension(125, 25));
        this.btnClearTamperFlag.setPreferredSize(new Dimension(125, 25));
        this.btnClearTamperFlag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnClearTamperFlagActionPerformed(evt);
            }
        });
        this.btnOpenPDF.setFont(new Font("Calibri", 0, 12));
        this.btnOpenPDF.setText("Open PDF Folder");
        this.btnOpenPDF.setToolTipText("Opens the PDF directory, where your generated reports are stored.");
        this.btnOpenPDF.setMaximumSize(new Dimension(125, 25));
        this.btnOpenPDF.setMinimumSize(new Dimension(125, 25));
        this.btnOpenPDF.setName("");
        this.btnOpenPDF.setPreferredSize(new Dimension(125, 25));
        this.btnOpenPDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnOpenPDFActionPerformed(evt);
            }
        });
        this.btnClearMemory.setFont(new Font("Calibri", 0, 12));
        this.btnClearMemory.setText("Reset Memory");
        this.btnClearMemory.setToolTipText("Reset memory to 0. Next test will overwrite previous data! Unless you have a specific reason to do this, use Clear Session!");
        this.btnClearMemory.setMaximumSize(new Dimension(125, 25));
        this.btnClearMemory.setMinimumSize(new Dimension(125, 25));
        this.btnClearMemory.setPreferredSize(new Dimension(125, 25));
        this.btnClearMemory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegacyUI.this.btnClearMemoryActionPerformed(evt);
            }
        });
        GroupLayout pnlRightButtonsLayout = new GroupLayout(this.pnlRightButtons);
        this.pnlRightButtons.setLayout(pnlRightButtonsLayout);
        pnlRightButtonsLayout.setHorizontalGroup(pnlRightButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRightButtonsLayout.createSequentialGroup().addContainerGap().addGroup(pnlRightButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnClearTamperFlag, -2, 136, -2).addGroup(pnlRightButtonsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.btnAllDataDump, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnDownloadSession, GroupLayout.Alignment.LEADING, -2, 136, -2)).addGroup(pnlRightButtonsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.btnClearMemory, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(btnGeneratePDF, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnEraseReconData, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnSyncTime, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnDisplaySettings, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(btnMainImages, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnExport, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnOpenPDF, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnOpenSavedFile, GroupLayout.Alignment.LEADING, -2, 136, -2))).addContainerGap()));
        pnlRightButtonsLayout.setVerticalGroup(pnlRightButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRightButtonsLayout.createSequentialGroup().addContainerGap().addComponent(this.btnDownloadSession, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAllDataDump, -2, -1, -2).addGap(7, 7, 7).addComponent(this.btnOpenSavedFile, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpenPDF, -2, 26, -2).addGap(6, 6, 6).addComponent(btnGeneratePDF, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnEraseReconData, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExport, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSyncTime, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDisplaySettings, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnMainImages, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearMemory, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearTamperFlag, -2, 26, -2).addContainerGap()));
        this.pnlVersInfo.setLayout((LayoutManager)new AbsoluteLayout());
        this.limiterLabel.setForeground(new Color(204, 0, 0));
        this.limiterLabel.setText("COUNT LIMITER = OFF");
        this.pnlVersInfo.add((Component)this.limiterLabel, new AbsoluteConstraints(6, 27, -1, -1));
        this.limiterLabel.getAccessibleContext().setAccessibleName("limiterLabel");
        lblVersion.setFont(new Font("Calibri", 0, 12));
        lblVersion.setText("v?");
        lblVersion.setToolTipText("");
        this.pnlVersInfo.add((Component)lblVersion, new AbsoluteConstraints(110, 10, -1, -1));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(lblSystemConsole, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnConnect, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(lblDataSessions, GroupLayout.Alignment.LEADING, -2, 181, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(lblReconSN, -1, 104, Short.MAX_VALUE).addComponent(lblFirmwareVersion, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, -1, -2).addComponent(txtLocation, -2, 223, -2).addComponent(this.lblLocation).addComponent(this.lblTestSiteInfo1, -2, 223, -2).addComponent(this.lblTestSiteInfo, -2, 223, -2).addComponent(this.jScrollPane2, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.pnlSessionInfo, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(btnConfig, -2, 92, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCloseProgram, -2, 92, -2)).addComponent(this.pnlSelectSession, -2, -1, -2)).addGap(107, 107, 107)))).addGroup(layout.createSequentialGroup().addComponent(this.lblRadonScoutQuickCal, -2, 620, -2).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlRightButtons, -2, -1, -2).addComponent(this.pnlVersInfo, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblRadonScoutQuickCal).addComponent(this.pnlVersInfo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnConnect, -2, 48, -2).addComponent(lblReconSN)).addComponent(lblFirmwareVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(lblSystemConsole).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblDataSessions, -2, 16, -2).addGap(18, 18, 18).addComponent(this.lblTestSiteInfo1, -2, 17, -2).addGap(0, 0, 0).addComponent(this.jScrollPane2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblTestSiteInfo, -2, 17, -2).addGap(2, 2, 2).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLocation, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(txtLocation, -2, 27, -2)).addGroup(layout.createSequentialGroup().addGap(168, 168, 168).addComponent(this.pnlSessionInfo, -2, -1, -2).addGap(27, 27, 27).addComponent(this.pnlSelectSession, -2, -1, -2)).addComponent(this.pnlRightButtons, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(btnConfig, -2, 40, -2).addComponent(this.btnCloseProgram, -2, 40, -2)).addContainerGap(36, Short.MAX_VALUE)));
        this.setSize(new Dimension(808, 711));
        this.setLocationRelativeTo(null);
    }

    private void btnConnectActionPerformed(ActionEvent evt) {
        AppUI.ConnectWorker worker = new AppUI.ConnectWorker();
        worker.execute();
    }

    private void btnClearMemoryActionPerformed(ActionEvent evt) {
        AppUI.ClearReconMemory worker = new AppUI.ClearReconMemory();
        worker.execute();
    }

    private void btnAllDataDumpActionPerformed(ActionEvent evt) {
        AppUI.AllDataDump worker = new AppUI.AllDataDump();
        worker.execute();
    }

    private void btnConfigActionPerformed(ActionEvent evt) {
        Config frameOptions = new Config();
        frameOptions.setDefaultCloseOperation(2);
        frameOptions.setLocationRelativeTo(this);
        frameOptions.setVisible(true);
    }

    private void btnDownloadSessionActionPerformed(ActionEvent evt) {
        AppUI.DownloadSession worker = new AppUI.DownloadSession();
        worker.execute();
    }

    private void btnOpenSavedFileActionPerformed(ActionEvent evt) {
        final JFileChooser SavedReconTXT_Dialog = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("RDT Data Files (txt, csv, json)", "txt", "csv", "json");
        SavedReconTXT_Dialog.setFileFilter(filter);
        File workingDirectory = InitDirs.dataDir;
        SavedReconTXT_Dialog.setCurrentDirectory(workingDirectory);
        int returnVal = SavedReconTXT_Dialog.showOpenDialog(null);
        if (returnVal == 0) {
            lblLoadedFile.setVisible(true);
            lblLoadedFileName.setVisible(true);
            LegacyUI.CloseGraphWindows();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        LoadSavedFile.main(SavedReconTXT_Dialog.getSelectedFile().getCanonicalPath());
                    }
                    catch (IOException ex) {
                        Logging.main("ERROR: Unable to determine file path for the loaded file!");
                    }
                }
            }).start();
        } else {
            lblLoadedFile.setVisible(false);
            lblLoadedFileName.setVisible(false);
        }
    }

    private void btnGeneratePDFActionPerformed(ActionEvent evt) {
        AppUI.GeneratePDF worker = new AppUI.GeneratePDF();
        worker.execute();
    }

    private void btnEraseReconDataActionPerformed(ActionEvent evt) {
        AppUI.ClearCurrentSession worker = new AppUI.ClearCurrentSession();
        worker.execute();
    }

    private void btnSyncTimeActionPerformed(ActionEvent evt) {
        AppUI.SyncReconTime worker = new AppUI.SyncReconTime();
        worker.execute();
    }

    private void btnOpenPDFActionPerformed(ActionEvent evt) {
        Desktop desktop = null;
        try {
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
                desktop.open(InitDirs.reportsDir);
            } else {
                Logging.main("ERROR: Opening PDF Folder!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void btnClearTamperFlagActionPerformed(ActionEvent evt) {
        AppUI.ClearTamperStatus worker = new AppUI.ClearTamperStatus();
        worker.execute();
    }

    private void txtLocationActionPerformed(ActionEvent evt) {
    }

    private void btnCloseProgramActionPerformed(ActionEvent evt) {
        this.CloseFile();
        System.exit(0);
    }

    private void cboSessionSelectActionPerformed(ActionEvent evt) {
        ReconProtocol.currentSession = cboSessionSelect.getSelectedIndex();
        TMProtocol.currentSession = cboSessionSelect.getSelectedIndex();
        this.RefreshDefaultFileName();
        this.chkUseStreetAddressForFilename.setSelected(false);
    }

    private void btnMainImagesActionPerformed(ActionEvent evt) {
        ImageSelectionPanel frameImages = new ImageSelectionPanel();
        frameImages.setDefaultCloseOperation(2);
        frameImages.setLocationRelativeTo(this);
        frameImages.setVisible(true);
    }

    private void btnDisplaySettingsActionPerformed(ActionEvent evt) {
        FlagForm flagOptions = new FlagForm();
        flagOptions.setDefaultCloseOperation(2);
        flagOptions.setLocationRelativeTo(this);
        flagOptions.setVisible(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.CloseFile();
        LegacyUI.CloseGraphWindows();
    }

    private void btnExportActionPerformed(ActionEvent evt) {
        this.ShowExportDialog(LoadSavedFile.strOpenFileName);
    }

    public static void main(String[] args) {
    }

    public static void ClearDeploymentFields() {
        txtCustomerInfo.setText("");
        txtTestSiteInfo.setText("");
        txtLocation.setText("");
    }

    protected static void CloseGraphWindows() {
        Window[] progWindows;
        for (Window window : progWindows = Window.getWindows()) {
            if (!window.getClass().toString().contains("MainMenu.CreateGraph")) continue;
            window.dispose();
        }
    }
}

