/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.AppUI;
import MainMenu.LoadSavedFile;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import MainMenu.MyJSONObject;
import MainMenu.ReconProtocol;
import MainMenu.TMProtocol;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.LinkedList;
import org.json.simple.JSONArray;

public class CreateJSONData {
    public static void main(LinkedList<String[]> dataSet, String outputFileName, boolean isTxtImport, boolean isFileUpdate) {
        LinkedList<String> jsonStrings = new LinkedList<String>();
        MyJSONObject objDataSamples = new MyJSONObject();
        MyJSONObject objTestDetails = new MyJSONObject();
        JSONArray arrDataSamples = new JSONArray();
        JSONArray arrTestDetails = new JSONArray();
        DecimalFormat cfDf = new DecimalFormat("0000");
        boolean cf1good = false;
        boolean cf2good = false;
        try {
            int sessionCounter;
            if (!isTxtImport && !isFileUpdate) {
                for (sessionCounter = 0; sessionCounter < dataSet.size(); ++sessionCounter) {
                    arrDataSamples.add(new MyJSONObject(Integer.toString(sessionCounter), String.join((CharSequence)":", dataSet.get(sessionCounter))));
                }
                arrTestDetails.add(new MyJSONObject("RDTVersion", MainMenuUI.appUI.version.trim()));
                switch (MainMenuUI.appUI.deviceType) {
                    case RECON: {
                        arrTestDetails.add(new MyJSONObject("InstrumentSerial", ReconProtocol.instrumentSerial.trim()));
                        arrTestDetails.add(new MyJSONObject("CalDate", ReconProtocol.calibrationDate.trim()));
                        arrTestDetails.add(new MyJSONObject("FirmwareVersion", ReconProtocol.firmwareVersion.trim()));
                        if (ReconProtocol.reconSession.getFirst().length > 15 && ReconProtocol.reconSession.getFirst()[2].contains("H")) {
                            if (Double.parseDouble(ReconProtocol.reconSession.getFirst()[15]) / 1000.0 > 3.0 && Double.parseDouble(ReconProtocol.reconSession.getFirst()[15]) / 1000.0 < 9.0) {
                                arrTestDetails.add(new MyJSONObject("Chamber1CF", ReconProtocol.reconSession.getFirst()[15].trim()));
                                cf1good = true;
                            }
                            if (Double.parseDouble(ReconProtocol.reconSession.getFirst()[16]) / 1000.0 > 3.0 && Double.parseDouble(ReconProtocol.reconSession.getFirst()[16]) / 1000.0 < 9.0) {
                                arrTestDetails.add(new MyJSONObject("Chamber2CF", ReconProtocol.reconSession.getFirst()[16].trim()));
                                cf2good = true;
                            }
                        }
                        if (!cf1good || !cf2good) {
                            arrTestDetails.add(new MyJSONObject("Chamber1CF", ReconProtocol.strConnectedReconCF1.trim()));
                            arrTestDetails.add(new MyJSONObject("Chamber2CF", ReconProtocol.strConnectedReconCF2.trim()));
                        }
                        arrTestDetails.add(new MyJSONObject("StartDateTime", ReconProtocol.strStartDateTime.trim()));
                        arrTestDetails.add(new MyJSONObject("EndDateTime", ReconProtocol.strEndDateTime.trim()));
                        break;
                    }
                    case CWLM: {
                        break;
                    }
                    default: {
                        arrTestDetails.add(new MyJSONObject("InstrumentSerial", TMProtocol.instrumentSerial.trim()));
                        arrTestDetails.add(new MyJSONObject("FirmwareVersion", TMProtocol.firmwareVersion.trim()));
                        arrTestDetails.add(new MyJSONObject("StartDateTime", TMProtocol.strStartDateTime.trim()));
                        arrTestDetails.add(new MyJSONObject("EndDateTime", TMProtocol.strEndDateTime.trim()));
                    }
                }
                arrTestDetails.add(new MyJSONObject("CustomerInformation", AppUI.txtCustomerInfo.getText().trim()));
                arrTestDetails.add(new MyJSONObject("TestSiteInformation", AppUI.txtTestSiteInfo.getText().trim()));
                arrTestDetails.add(new MyJSONObject("Protocol", AppUI.txtMainProtocol.getText().trim()));
                arrTestDetails.add(new MyJSONObject("Tampering", AppUI.txtMainTampering.getText().trim()));
                arrTestDetails.add(new MyJSONObject("Weather", AppUI.txtMainWeather.getText().trim()));
                arrTestDetails.add(new MyJSONObject("Mitigation", AppUI.txtMainMitigation.getText().trim()));
                arrTestDetails.add(new MyJSONObject("Comment", AppUI.txtMainComment.getText().trim()));
                arrTestDetails.add(new MyJSONObject("Location", AppUI.txtLocation.getText().trim()));
                arrTestDetails.add(new MyJSONObject("DeployedBy", AppUI.txtMainDeployedBy.getText().trim()));
                arrTestDetails.add(new MyJSONObject("RetrievedBy", AppUI.txtMainRetrievedBy.getText().trim()));
                arrTestDetails.add(new MyJSONObject("AnalyzedBy", AppUI.txtMainAnalyzedBy.getText().trim()));
            } else if (isTxtImport || isFileUpdate) {
                sessionCounter = 0;
                String dataSample = "";
                while (!dataSample.contains("Z")) {
                    dataSample = String.join((CharSequence)":", dataSet.get(sessionCounter));
                    dataSample = dataSample.replace("[", "").replace("]", "");
                    arrDataSamples.add(new MyJSONObject(Integer.toString(sessionCounter), dataSample));
                    ++sessionCounter;
                }
                if (isTxtImport) {
                    arrTestDetails.add(new MyJSONObject("RDTVersion", MainMenuUI.appUI.version.trim()));
                    arrTestDetails.add(new MyJSONObject("InstrumentSerial", LoadSavedFile.strInstrumentSerial.trim()));
                    arrTestDetails.add(new MyJSONObject("CalDate", LoadSavedFile.strCalDate.trim()));
                    arrTestDetails.add(new MyJSONObject("FirmwareVersion", LoadSavedFile.strFirmwareVersion.trim()));
                    arrTestDetails.add(new MyJSONObject("Chamber1CF", cfDf.format(LoadSavedFile.LoadedReconCF1 * 1000.0).trim()));
                    arrTestDetails.add(new MyJSONObject("Chamber2CF", cfDf.format(LoadSavedFile.LoadedReconCF2 * 1000.0).trim()));
                    arrTestDetails.add(new MyJSONObject("CustomerInformation", LoadSavedFile.strCustomerInfo.trim()));
                    arrTestDetails.add(new MyJSONObject("TestSiteInformation", LoadSavedFile.strTestSiteInfo.trim()));
                    arrTestDetails.add(new MyJSONObject("StartDateTime", LoadSavedFile.strStartDate.trim()));
                    arrTestDetails.add(new MyJSONObject("EndDateTime", LoadSavedFile.strEndDate.trim()));
                    arrTestDetails.add(new MyJSONObject("Protocol", LoadSavedFile.strReportProtocol.trim()));
                    arrTestDetails.add(new MyJSONObject("Tampering", LoadSavedFile.strReportTampering.trim()));
                    arrTestDetails.add(new MyJSONObject("Weather", LoadSavedFile.strReportWeather.trim()));
                    arrTestDetails.add(new MyJSONObject("Mitigation", LoadSavedFile.strReportMitigation.trim()));
                    arrTestDetails.add(new MyJSONObject("Comment", LoadSavedFile.strReportComment.trim()));
                    arrTestDetails.add(new MyJSONObject("Location", LoadSavedFile.strLocation.trim()));
                    arrTestDetails.add(new MyJSONObject("DeployedBy", LoadSavedFile.strDeployedBy.trim()));
                    arrTestDetails.add(new MyJSONObject("RetrievedBy", LoadSavedFile.strRetrievedBy.trim()));
                    arrTestDetails.add(new MyJSONObject("AnalyzedBy", LoadSavedFile.strAnalyzedBy.trim()));
                } else if (isFileUpdate) {
                    arrTestDetails.add(new MyJSONObject("RDTVersion", MainMenuUI.appUI.version.trim()));
                    arrTestDetails.add(new MyJSONObject("InstrumentSerial", LoadSavedFile.strInstrumentSerial.trim()));
                    arrTestDetails.add(new MyJSONObject("CalDate", LoadSavedFile.strCalDate.trim()));
                    arrTestDetails.add(new MyJSONObject("FirmwareVersion", LoadSavedFile.strFirmwareVersion.trim()));
                    arrTestDetails.add(new MyJSONObject("Chamber1CF", cfDf.format(LoadSavedFile.LoadedReconCF1 * 1000.0).trim()));
                    arrTestDetails.add(new MyJSONObject("Chamber2CF", cfDf.format(LoadSavedFile.LoadedReconCF2 * 1000.0).trim()));
                    arrTestDetails.add(new MyJSONObject("CustomerInformation", AppUI.txtCustomerInfo.getText().toString().trim()));
                    arrTestDetails.add(new MyJSONObject("TestSiteInformation", AppUI.txtTestSiteInfo.getText().toString().trim()));
                    arrTestDetails.add(new MyJSONObject("StartDateTime", LoadSavedFile.strStartDate.trim()));
                    arrTestDetails.add(new MyJSONObject("EndDateTime", LoadSavedFile.strEndDate.trim()));
                    if (MainMenuUI.appUI instanceof MainMenuUI) {
                        arrTestDetails.add(new MyJSONObject("Protocol", MainMenuUI.txtMainProtocol.getText().toString().trim()));
                    } else {
                        arrTestDetails.add(new MyJSONObject("Protocol", LoadSavedFile.strReportProtocol.trim()));
                    }
                    if (MainMenuUI.appUI instanceof MainMenuUI) {
                        arrTestDetails.add(new MyJSONObject("Tampering", MainMenuUI.txtMainTampering.getText().toString().trim()));
                    } else {
                        arrTestDetails.add(new MyJSONObject("Tampering", LoadSavedFile.strReportTampering.trim()));
                    }
                    if (MainMenuUI.appUI instanceof MainMenuUI) {
                        arrTestDetails.add(new MyJSONObject("Weather", MainMenuUI.txtMainWeather.getText().toString().trim()));
                    } else {
                        arrTestDetails.add(new MyJSONObject("Weather", LoadSavedFile.strReportWeather.trim()));
                    }
                    if (MainMenuUI.appUI instanceof MainMenuUI) {
                        arrTestDetails.add(new MyJSONObject("Mitigation", MainMenuUI.txtMainMitigation.getText().toString().trim()));
                    } else {
                        arrTestDetails.add(new MyJSONObject("Mitigation", LoadSavedFile.strReportMitigation.trim()));
                    }
                    if (MainMenuUI.appUI instanceof MainMenuUI) {
                        arrTestDetails.add(new MyJSONObject("Comment", MainMenuUI.txtMainComment.getText().toString().trim()));
                    } else {
                        arrTestDetails.add(new MyJSONObject("Comment", LoadSavedFile.strReportComment.trim()));
                    }
                    arrTestDetails.add(new MyJSONObject("Location", AppUI.txtLocation.getText().toString().trim()));
                    if (MainMenuUI.appUI instanceof MainMenuUI) {
                        arrTestDetails.add(new MyJSONObject("DeployedBy", MainMenuUI.txtMainDeployedBy.getText().toString().trim()));
                    } else {
                        arrTestDetails.add(new MyJSONObject("DeployedBy", LoadSavedFile.strDeployedBy.trim()));
                    }
                    if (MainMenuUI.appUI instanceof MainMenuUI) {
                        arrTestDetails.add(new MyJSONObject("RetrievedBy", MainMenuUI.txtMainRetrievedBy.getText().toString().trim()));
                    } else {
                        arrTestDetails.add(new MyJSONObject("RetrievedBy", LoadSavedFile.strRetrievedBy.trim()));
                    }
                    if (MainMenuUI.appUI instanceof MainMenuUI) {
                        arrTestDetails.add(new MyJSONObject("AnalyzedBy", MainMenuUI.txtMainAnalyzedBy.getText().toString().trim()));
                    } else {
                        arrTestDetails.add(new MyJSONObject("AnalyzedBy", LoadSavedFile.strAnalyzedBy.trim()));
                    }
                }
            }
            objDataSamples.put("DataSamples", arrDataSamples);
            objTestDetails.put("TestDetails", arrTestDetails);
            jsonStrings.add("[\n\n");
            jsonStrings.add(objDataSamples.toJSONArrayElementString());
            jsonStrings.add(objTestDetails.toJSONString());
            jsonStrings.add("\n\n]");
            PrintWriter pw = new PrintWriter(outputFileName);
            for (int i = 0; i < jsonStrings.size(); ++i) {
                pw.write((String)jsonStrings.get(i));
            }
            pw.close();
        }
        catch (Exception anyEx) {
            StringWriter sw = new StringWriter();
            PrintWriter tempPW = new PrintWriter(sw);
            Logging.main("ERROR: Unable to create data json file!");
            anyEx.printStackTrace(tempPW);
            Logging.main(sw.toString());
        }
    }
}

