/*
 * Decompiled with CFR 0.152.
 */
package Config;

import Config.Config;
import MainMenu.Logging;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ImageEditor {
    private JFrame frmSelectAreaIn;
    private JPanel selectedAreaPanel;
    private JScrollPane imageScroller;
    private String imagePath;
    private File finalFile;
    private BufferedImage finalImage = null;
    private Config configToUpdate;

    public static void main(String[] args) {
    }

    public ImageEditor(String filename, File fileToWrite, Config configInstance) throws IOException {
        this.imagePath = filename;
        this.finalFile = fileToWrite;
        this.configToUpdate = configInstance;
        this.initialize();
    }

    private void initialize() throws IOException {
        this.frmSelectAreaIn = new JFrame();
        this.frmSelectAreaIn.setTitle("Import Signature/Company Logo");
        this.frmSelectAreaIn.setBounds(100, 100, 1024, 768);
        this.frmSelectAreaIn.setDefaultCloseOperation(3);
        this.frmSelectAreaIn.getContentPane().setLayout(null);
        this.frmSelectAreaIn.setAlwaysOnTop(true);
        this.selectedAreaPanel = new JPanel();
        this.selectedAreaPanel.setBounds(10, 425, 875, 400);
        this.frmSelectAreaIn.getContentPane().add(this.selectedAreaPanel);
        ImagePanel mainPanel = new ImagePanel(this.imagePath, this);
        this.imageScroller = new JScrollPane(mainPanel, 20, 30);
        this.imageScroller.setBounds(10, 11, 875, 400);
        this.frmSelectAreaIn.getContentPane().add(this.imageScroller);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        JButton btnDoneEditing = new JButton("Accept");
        JButton btnCancelEditing = new JButton("Cancel");
        btnDoneEditing.addActionListener(e -> this.actionBtnDoneEditingPerformed());
        btnCancelEditing.addActionListener(e -> this.actionBtnCancelEditingPerformed());
        buttonPanel.add(btnDoneEditing);
        buttonPanel.add(btnCancelEditing);
        buttonPanel.setBounds(915, 10, 221, 125);
        this.frmSelectAreaIn.getContentPane().add(buttonPanel);
        JLabel lblSelectedArea = new JLabel("Final Image");
        lblSelectedArea.setBounds(469, 11, 221, 14);
        this.frmSelectAreaIn.getContentPane().add(lblSelectedArea);
        this.frmSelectAreaIn.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ImageEditor.this.configToUpdate.UpdatePreviews();
            }
        });
        this.frmSelectAreaIn.setDefaultCloseOperation(2);
        this.frmSelectAreaIn.setLocationRelativeTo(null);
        this.frmSelectAreaIn.setVisible(true);
    }

    public void updateSelectedRegion(BufferedImage bufferedImage) {
        Graphics g = this.selectedAreaPanel.getGraphics();
        g.clearRect(0, 0, 875, 400);
        g.drawImage(bufferedImage, 0, 0, null);
    }

    private void actionBtnDoneEditingPerformed() {
        try {
            ImageIO.write((RenderedImage)this.finalImage, "png", this.finalFile);
            this.frmSelectAreaIn.dispose();
        }
        catch (Exception anyEx) {
            Logging.main("CONFIG: Error writing updated signature/logo image!");
            Logging.main(anyEx.toString());
            anyEx.printStackTrace();
        }
    }

    private void actionBtnCancelEditingPerformed() {
        this.frmSelectAreaIn.dispose();
    }

    public class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private BufferedImage image;
        private Shape shape = null;
        Point startDrag;
        Point endDrag;

        public ImagePanel(String inputImage, ImageEditor mf1) throws IOException {
            final ImageEditor mf = mf1;
            this.image = ImageIO.read(new File(inputImage));
            ImageEditor.this.finalImage = this.image;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ImagePanel.this.endDrag = ImagePanel.this.startDrag = new Point(e.getX(), e.getY());
                    ImagePanel.this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (ImagePanel.this.endDrag != null && ImagePanel.this.startDrag != null) {
                        try {
                            ImagePanel.this.shape = ImagePanel.this.makeRectangle(ImagePanel.this.startDrag.x, ImagePanel.this.startDrag.y, e.getX(), e.getY());
                            mf.updateSelectedRegion(ImagePanel.this.image.getSubimage(ImagePanel.this.startDrag.x, ImagePanel.this.startDrag.y, e.getX() - ImagePanel.this.startDrag.x, e.getY() - ImagePanel.this.startDrag.y));
                            ImageEditor.this.finalImage = ImagePanel.this.image.getSubimage(ImagePanel.this.startDrag.x, ImagePanel.this.startDrag.y, e.getX() - ImagePanel.this.startDrag.x, e.getY() - ImagePanel.this.startDrag.y);
                            ImagePanel.this.startDrag = null;
                            ImagePanel.this.endDrag = null;
                            ImagePanel.this.repaint();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    ImagePanel.this.endDrag = new Point(e.getX(), e.getY());
                    ImagePanel.this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage((Image)this.image, 0, 0, null);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(new BasicStroke(2.0f));
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            if (this.shape != null) {
                g2.setPaint(Color.BLACK);
                g2.draw(this.shape);
                g2.setPaint(Color.YELLOW);
                g2.fill(this.shape);
            }
            if (this.startDrag != null && this.endDrag != null) {
                g2.setPaint(Color.LIGHT_GRAY);
                Rectangle2D.Float r = this.makeRectangle(this.startDrag.x, this.startDrag.y, this.endDrag.x, this.endDrag.y);
                g2.draw(r);
            }
        }

        private Rectangle2D.Float makeRectangle(int x1, int y1, int x2, int y2) {
            return new Rectangle2D.Float(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1 - x2), Math.abs(y1 - y2));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(3000, 3000);
        }
    }
}

