/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import Config.FlagForm;
import MainMenu.AppUI;
import MainMenu.CountLimiter;
import MainMenu.InitDirs;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import MainMenu.ReadComm;
import MainMenu.ScanComm;
import MainMenu.WriteComm;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ReconProtocol {
    public static String ReconConfirm = ":RV\n";
    public static String ReadProtocol = ":RP\n";
    public static String CheckNewRecord = ":RB\n";
    public static String ReadNextRecord = ":RN\n";
    public static String ReadFirstRecord = ":RN0\n";
    public static String ReadNextDiagnosticRecord = ":DN\n";
    public static String ReadFirstDiagnosticRecord = ":DN0\n";
    public static String ClearMemoryCommand = ":CM\n";
    public static String ClearSessionCommand = ":CD\n";
    public static String ReadCalibrationFactors = ":RL\n";
    public static String ReadTime = ":RT\n";
    public static String ResetTamperFlag = ":WX\n";
    public static String WriteOptionsFlag = ":WF";
    public static String ReadOptionsFlag = ":RF\n";
    public static String ReadPointerTable = ":CN\n";
    public static String DeviceResponse;
    public static String[] DeviceResponse_parsed;
    public static LinkedList<String[]> reconSession;
    public static LinkedList<Integer> sessionAddresses;
    public static LinkedList<String> reconSessionStrings;
    public static int currentSession;
    public static String[] pointerTable_raw;
    public static String filenameJSON;
    public static String defaultFilename;
    public static String instrumentSerial;
    public static String firmwareVersion;
    public static String calibrationDate;
    public static String strStartDateTime;
    public static String strEndDateTime;
    public static String strConnectedReconCF1;
    public static String strConnectedReconCF2;
    public static int numDataRecords;

    ReconProtocol() {
    }

    public static String GetSerialNumber() {
        WriteComm.main(ScanComm.scannedPort, ReconConfirm);
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
        return DeviceResponse_parsed[3];
    }

    public static void LoadNewRecord() {
        WriteComm.main(ScanComm.scannedPort, CheckNewRecord);
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
    }

    public static void LoadNextRecord() {
        WriteComm.main(ScanComm.scannedPort, ReadNextRecord);
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
    }

    public static void LoadSpecifiedRecord(String number) {
        WriteComm.main(ScanComm.scannedPort, ":RN" + number + "\n");
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
    }

    public static void LoadSpecifiedRecord(int number) {
        WriteComm.main(ScanComm.scannedPort, ":RN" + Integer.toString(number) + "\n");
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
    }

    public static String GetSpecifiedRecordCommand(int number) {
        String result = ":RN" + Integer.toString(number);
        return result.trim();
    }

    public static void SetReconTimeFromPC() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yy,MM,dd,HH,mm,ss");
        LocalDateTime currentTime = LocalDateTime.now();
        String strCurrentTime = currentTime.format(formatter);
        Logging.main("Issuing :WT instruction to write time...");
        WriteComm.main(ScanComm.scannedPort, ":WT," + strCurrentTime + "\n");
    }

    public static void GetPointerTable() {
        pointerTable_raw = new String[16];
        sessionAddresses.clear();
        WriteComm.main(ScanComm.scannedPort, ReadPointerTable);
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
        String oldestSessionString = DeviceResponse_parsed[1];
        oldestSessionString = oldestSessionString.trim();
        int oldestSession = Integer.parseInt(oldestSessionString);
        int numSessions = MainMenuUI.appUI.getDataSessions();
        int rawAddressIndex = 0;
        for (int i = 0; i < 19; ++i) {
            if (i < 3) continue;
            ReconProtocol.pointerTable_raw[rawAddressIndex] = DeviceResponse_parsed[i];
            ++rawAddressIndex;
        }
        rawAddressIndex = oldestSession;
        for (int j = 0; j < numSessions; ++j) {
            if (rawAddressIndex == 16) {
                rawAddressIndex = 0;
            }
            String tempString = pointerTable_raw[rawAddressIndex];
            tempString = tempString.trim();
            sessionAddresses.add(Integer.parseInt(tempString));
            ++rawAddressIndex;
        }
    }

    public static void GetPointerTableRCT() {
        pointerTable_raw = new String[16];
        sessionAddresses.clear();
        WriteComm.main(ScanComm.scannedPort, ReadPointerTable);
        DeviceResponse = ReadComm.main(ScanComm.scannedPort, 19);
        DeviceResponse = DeviceResponse.replaceAll("[\\n\\r+]", "");
        DeviceResponse_parsed = DeviceResponse.split(",");
        int nextSessionIndex = Integer.parseInt(DeviceResponse_parsed[2]);
        int rawAddressIndex = 0;
        for (int i = 0; i < 19; ++i) {
            if (i < 3) continue;
            ReconProtocol.pointerTable_raw[rawAddressIndex] = DeviceResponse_parsed[i];
            ++rawAddressIndex;
        }
        while (sessionAddresses.size() < 16) {
            if (nextSessionIndex == 16) {
                nextSessionIndex = 0;
            }
            sessionAddresses.add(Integer.parseInt(pointerTable_raw[nextSessionIndex].trim()));
            ++nextSessionIndex;
        }
    }

    public static boolean DownloadReconSessionToRAM() throws InterruptedException {
        DateTimeFormatter DateTimeDisplay = DateTimeFormatter.ofPattern("MM-dd-yyyy HH:mm");
        int numReReadAttempts = 1;
        int maxNumReReadAttempts = 5;
        if (reconSession != null) {
            reconSession.clear();
        } else {
            reconSession = new LinkedList();
        }
        ReconProtocol.LoadSpecifiedRecord(sessionAddresses.get(currentSession));
        if (DeviceResponse_parsed.length == 1) {
            Logging.main("Session pointer pointing to null record. Aborting download.");
            return false;
        }
        int recordIterator = Integer.parseInt(DeviceResponse_parsed[1]);
        if (AppUI.countLimiter) {
            reconSession.add(CountLimiter.main(DeviceResponse_parsed));
        } else {
            reconSession.add(DeviceResponse_parsed);
        }
        while (!DeviceResponse_parsed[2].equals("Z")) {
            int baseYear;
            if (++recordIterator > numDataRecords) {
                recordIterator = -1;
                continue;
            }
            ReconProtocol.LoadNextRecord();
            if (DeviceResponse_parsed.length == 1) {
                Logging.main("Null record found in session. Skipping.");
                continue;
            }
            MainMenuUI.appUI.displayProgressLabel("Reading Record #" + DeviceResponse_parsed[1] + "...");
            if (DeviceResponse_parsed[2].equals("D")) continue;
            if (DeviceResponse_parsed[2].equals("S")) {
                baseYear = 2000 + Integer.parseInt(DeviceResponse_parsed[3]);
                LocalDateTime startDateTime = LocalDateTime.of(baseYear, Integer.parseInt(DeviceResponse_parsed[4]), Integer.parseInt(DeviceResponse_parsed[5]), Integer.parseInt(DeviceResponse_parsed[6]), Integer.parseInt(DeviceResponse_parsed[7]), Integer.parseInt(DeviceResponse_parsed[8]));
                strStartDateTime = DateTimeDisplay.format(startDateTime);
            }
            if (DeviceResponse_parsed[2].equals("E")) {
                baseYear = 2000 + Integer.parseInt(DeviceResponse_parsed[3]);
                LocalDateTime endDateTime = LocalDateTime.of(baseYear, Integer.parseInt(DeviceResponse_parsed[4]), Integer.parseInt(DeviceResponse_parsed[5]), Integer.parseInt(DeviceResponse_parsed[6]), Integer.parseInt(DeviceResponse_parsed[7]), Integer.parseInt(DeviceResponse_parsed[8]));
                strEndDateTime = DateTimeDisplay.format(endDateTime);
            }
            if (recordIterator != Integer.parseInt(DeviceResponse_parsed[1])) {
                while (recordIterator != Integer.parseInt(DeviceResponse_parsed[1]) || numReReadAttempts <= 5) {
                    Logging.main("Re-reading sample #" + Integer.toString(recordIterator));
                    ReconProtocol.LoadSpecifiedRecord(Integer.toString(recordIterator));
                    if (recordIterator == Integer.parseInt(DeviceResponse_parsed[1])) continue;
                    ++numReReadAttempts;
                }
            }
            if (AppUI.countLimiter) {
                reconSession.add(CountLimiter.main(DeviceResponse_parsed));
            } else {
                reconSession.add(DeviceResponse_parsed);
            }
            if (Integer.parseInt(DeviceResponse_parsed[1]) != numDataRecords) continue;
            recordIterator = -1;
        }
        return true;
    }

    public static boolean DownloadReconSessionToRAMRCT() throws InterruptedException {
        int numDataRecords = (double)Float.parseFloat(firmwareVersion) >= 1.34 ? 6043 : 6143;
        ReconProtocol.ClearSessionStrings();
        if (sessionAddresses.getLast() == 0) {
            Logging.main("WARNING: Attempting to download a previously cleared session from address 0!");
            Logging.main("WARNING: If this was attempted right after a :CM, the session will be incomplete or the wrong data!");
            Logging.main("WARNING: It is also possible the last session did start at 0. Careful analysis recommended!");
        }
        ReconProtocol.LoadSpecifiedRecord(sessionAddresses.getLast());
        if (DeviceResponse_parsed.length == 1) {
            return false;
        }
        int recordIterator = Integer.parseInt(DeviceResponse_parsed[1]);
        reconSession.add(CountLimiter.main(DeviceResponse_parsed));
        reconSessionStrings.add(DeviceResponse);
        while (!DeviceResponse_parsed[2].equals("Z")) {
            ++recordIterator;
            ReconProtocol.LoadNextRecord();
            if (DeviceResponse_parsed.length == 1 || DeviceResponse_parsed[2].equals("D")) continue;
            if (recordIterator != Integer.parseInt(DeviceResponse_parsed[1])) {
                ReconProtocol.LoadSpecifiedRecord(Integer.toString(recordIterator));
            }
            reconSession.add(CountLimiter.main(DeviceResponse_parsed));
            reconSessionStrings.add(DeviceResponse);
            if (Integer.parseInt(DeviceResponse_parsed[1]) != numDataRecords) continue;
            recordIterator = -1;
        }
        return true;
    }

    public static void SetDefaultFilename(int sessionIndex) {
        ReconProtocol.LoadSpecifiedRecord(sessionIndex + 1);
        defaultFilename = "Recon_" + instrumentSerial + "_" + DeviceResponse_parsed[4] + DeviceResponse_parsed[5] + DeviceResponse_parsed[3];
    }

    public static String GetSessionDescription(int sessionStartPoint) {
        String description;
        if (sessionStartPoint < numDataRecords) {
            ReconProtocol.LoadSpecifiedRecord(sessionStartPoint + 1);
        } else {
            ReconProtocol.LoadSpecifiedRecord(0);
        }
        if (DeviceResponse_parsed.length > 1) {
            if (DeviceResponse_parsed[2].contains("W")) {
                description = DeviceResponse_parsed[4] + "/" + DeviceResponse_parsed[5] + "/" + DeviceResponse_parsed[3] + " @ " + DeviceResponse_parsed[6] + ":" + DeviceResponse_parsed[7] + ":" + DeviceResponse_parsed[8];
            } else {
                Logging.main("Read bad value when attempting to get session description string (arm date). Skipping...");
                description = "null";
            }
        } else {
            Logging.main("Read bad value when attempting to get session description string (arm date). Skipping...");
            description = "null";
        }
        return description;
    }

    /*
     * Unable to fully structure code
     */
    public static void DetermineFileName() {
        JSON_name = null;
        JSON_exists = false;
        JSON_file = null;
        acceptableFilenameChars = Pattern.compile("[a-zA-Z0-9\\-\\_\\.\\s\\,]*");
        testSiteArray = AppUI.txtTestSiteInfo.getText().split("\\r?\\n");
        testSite = testSiteArray[0];
        testSite = testSite.replaceAll("[\\n\\r+]", "");
        if (!MainMenuUI.appUI.chkUseStreetAddressForFilename.isSelected()) ** GOTO lbl-1000
        if (AppUI.txtTestSiteInfo.getText().length() > 0) {
            patternMatcher = acceptableFilenameChars.matcher(testSite);
            if (!patternMatcher.matches()) {
                MainMenuUI.appUI.invalidFilename = true;
                JSON_name = InitDirs.dataDir + File.separator + ReconProtocol.defaultFilename + ".json";
            } else {
                while (testSite.endsWith(".") || testSite.endsWith(" ")) {
                    testSite = testSite.substring(0, testSite.length() - 1);
                }
                JSON_name = InitDirs.dataDir + File.separator + testSite + ".json";
                MainMenuUI.appUI.invalidFilename = false;
            }
        } else if (!(patternMatcher = acceptableFilenameChars.matcher(MainMenuUI.appUI.txtNewFileName.getText())).matches()) {
            MainMenuUI.appUI.invalidFilename = true;
            JSON_name = InitDirs.dataDir + File.separator + ReconProtocol.defaultFilename + ".json";
        } else if (MainMenuUI.appUI.txtNewFileName.getText().length() > 0) {
            while (MainMenuUI.appUI.txtNewFileName.getText().endsWith(".") || MainMenuUI.appUI.txtNewFileName.getText().endsWith(" ")) {
                MainMenuUI.appUI.txtNewFileName.setText(MainMenuUI.appUI.txtNewFileName.getText().substring(0, MainMenuUI.appUI.txtNewFileName.getText().length() - 1));
            }
            JSON_name = InitDirs.dataDir + File.separator + MainMenuUI.appUI.txtNewFileName.getText() + ".json";
            MainMenuUI.appUI.invalidFilename = false;
        } else {
            JSON_name = InitDirs.dataDir + File.separator + ReconProtocol.defaultFilename + ".json";
            MainMenuUI.appUI.invalidFilename = false;
        }
        ReconProtocol.filenameJSON = new String(JSON_name);
    }

    public static void SetOptionFlag() {
        int flag = 0;
        if (FlagForm.displayPreferencePres == "mBar") {
            flag = (short)(flag + 1);
        }
        if (FlagForm.displayPreferenceTemp == "C") {
            flag = (short)(flag + 4);
        }
        if (FlagForm.displayPreferenceDual == "yes") {
            flag = (short)(flag + 16);
        }
        if (FlagForm.displayPreferenceUnits == "Bq/m3") {
            flag = (short)(flag + 32);
        }
        if (FlagForm.displayPreferenceUnits == "CPH") {
            flag = (short)(flag + 64);
        }
        if (FlagForm.displayPreferenceNoAvg == "Ten Mins.") {
            flag = (short)(flag + 128);
        }
        if (FlagForm.displayPreferenceAvgFirstFourHours == "Yes") {
            flag = (short)(flag + 256);
        }
        if (FlagForm.displayPreferenceBlind == "Yes") {
            flag = (short)(flag + 8);
        }
        Logging.main("Attempting to write flag: " + Integer.toHexString(flag));
        WriteComm.main(ScanComm.scannedPort, WriteOptionsFlag + Integer.toHexString(flag) + "\n");
    }

    public static void ParseOptionFlag() {
        WriteComm.main(ScanComm.scannedPort, ReadOptionsFlag);
        try {
            Thread.sleep(125L);
            String parsedFlag = ReadComm.main(ScanComm.scannedPort, 19);
            parsedFlag = parsedFlag.replaceAll("[\\n\\r+]", "");
            parsedFlag = parsedFlag.replaceAll("=RF", "");
            Logging.main("ParseOptionFlag(): Parsed flag value is: " + parsedFlag);
            int flagValue = Integer.parseInt(parsedFlag, 16);
            FlagForm.displayPreferenceTemp = (flagValue & 4) == 0 ? "F" : "C";
            FlagForm.displayPreferencePres = (flagValue & 1) == 0 ? "inHG" : "mBar";
            if ((flagValue & 0x20) == 0 && (flagValue & 0x40) == 0) {
                FlagForm.displayPreferenceUnits = "pCi/L";
            } else if ((flagValue & 0x20) != 0) {
                FlagForm.displayPreferenceUnits = "Bq/m3";
            } else if ((flagValue & 0x40) != 0) {
                FlagForm.displayPreferenceUnits = "CPH";
            }
            FlagForm.displayPreferenceDual = (flagValue & 0x10) == 0 ? "no" : "yes";
            FlagForm.displayPreferenceNoAvg = (flagValue & 0x80) == 0 ? "Hourly" : "Ten Mins.";
            FlagForm.displayPreferenceAvgFirstFourHours = (flagValue & 0x100) == 0 ? "No" : "Yes";
            FlagForm.displayPreferenceBlind = (flagValue & 8) == 0 ? "No" : "Yes";
        }
        catch (Exception anyEx) {
            Logging.main(anyEx.toString());
        }
    }

    public static void ClearTamperFlag() {
        WriteComm.main(ScanComm.scannedPort, ResetTamperFlag);
    }

    public static void SetNumDataRecords() {
        Pattern forbiddenChars = Pattern.compile("[a-zA-Z]");
        Matcher patternMatcher = forbiddenChars.matcher(ScanComm.ReconFirmwareVersion);
        if (patternMatcher.find()) {
            Logging.main("Firmware version unexpected format. Assuming 6043 data records.");
            Logging.main(ScanComm.ReconFirmwareVersion);
            numDataRecords = 6043;
        } else {
            numDataRecords = (double)Float.parseFloat(ScanComm.ReconFirmwareVersion) >= 1.34 ? 6043 : 6143;
        }
    }

    public static void ClearSessionStrings() {
        if (reconSession != null) {
            reconSession.clear();
        } else {
            reconSession = new LinkedList();
        }
        if (reconSessionStrings != null) {
            reconSessionStrings.clear();
        } else {
            reconSessionStrings = new LinkedList();
        }
    }

    static {
        sessionAddresses = new LinkedList();
        instrumentSerial = "not set";
        firmwareVersion = "not set";
        calibrationDate = "not set";
        strStartDateTime = "not set";
        strEndDateTime = "not set";
        strConnectedReconCF1 = "not set";
        strConnectedReconCF2 = "not set";
    }
}

