/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.AppUI;
import MainMenu.Logging;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import javax.swing.JFileChooser;

public class InitDirs {
    public static boolean boolMacOS = false;
    public static boolean boolWindows = false;
    public static String strOperatingSystem = System.getProperty("os.name");
    public static String userHomeDirectory = System.getProperty("user.home");
    public static File baseDir = new File("ReconDownloadTool");
    public static File configDir = new File("config");
    public static File dataDir = new File("data");
    public static File fontsDir = new File("fonts");
    public static File logsDir = new File("logs");
    public static File reportsDir = new File("reports");
    public static File imagesDir = new File("images");
    public static File appDir = new File("");
    public static AppUI appUI = new AppUI();

    public static void main() {
        InitDirs.findOperatingSystem();
        InitDirs.assignWorkingDirectories();
        if (!logsDir.exists()) {
            System.out.println("Logs directory does not exist. Creating...");
            logsDir.mkdirs();
            Logging.createLogFile();
        }
        Logging.main("Recon Download Tool Version = " + InitDirs.appUI.version);
        Logging.main("Operating System: " + strOperatingSystem);
        InitDirs.showAppDirectory();
        if (!configDir.exists()) {
            Logging.main("Config directory does not exist.  Creating...");
            configDir.mkdirs();
            InitDirs.copySourceFileToUserDirectory("config", configDir, "signature.png");
            InitDirs.copySourceFileToUserDirectory("config", configDir, "signature.jpg");
            InitDirs.copySourceFileToUserDirectory("config", configDir, "logo.png");
        }
        if (!dataDir.exists()) {
            Logging.main("Data directory does not exist.  Creating...");
            dataDir.mkdirs();
        }
        if (!fontsDir.exists()) {
            Logging.main("WARNING: Fonts directory is not found or does not exist.");
            Logging.main("WARNING: Attempted Fonts directory = " + fontsDir);
        }
        if (!reportsDir.exists()) {
            Logging.main("Reports directory does not exist.  Creating...");
            reportsDir.mkdirs();
        }
    }

    public static void findOperatingSystem() {
        boolMacOS = strOperatingSystem.startsWith("Mac");
        boolWindows = strOperatingSystem.contains("Win");
    }

    public static void showAppDirectory() {
        try {
            System.out.println("Application Directory (JAR file location) = " + appDir.getAbsolutePath());
        }
        catch (Exception ex) {
            Logging.main("ERROR: Unable to find application directory!");
        }
    }

    public static void copySourceFileToUserDirectory(String strSource, File fileDestination, String strFileName) {
        try {
            File sourceDir = new File(strSource + File.separator + strFileName);
            if (sourceDir.exists()) {
                File targetDir = new File(fileDestination.toString() + File.separator + strFileName);
                Files.copy(sourceDir.toPath(), targetDir.toPath(), new CopyOption[0]);
            } else {
                Logging.main("WARNING: Unable to resolve application source directory in copySourceFileToUserDir (" + strSource + File.separator + strFileName + ")!");
            }
        }
        catch (IOException ex) {
            Logging.main("ERROR: copySourceFileToUserDir!");
        }
    }

    public static void assignWorkingDirectories() {
        try {
            if (boolMacOS) {
                baseDir = boolMacOS ? new File(userHomeDirectory + File.separator + "Documents" + File.separator + "ReconDownloadTool") : new File("ReconDownloadTool");
                configDir = boolMacOS ? new File(userHomeDirectory + File.separator + "Documents" + File.separator + "ReconDownloadTool" + File.separator + "config") : new File("config");
                dataDir = boolMacOS ? new File(userHomeDirectory + File.separator + "Documents" + File.separator + "ReconDownloadTool" + File.separator + "data") : new File("data");
                fontsDir = boolMacOS ? new File(new File("ReconDownloadTool.app").getAbsolutePath() + File.separator + "Contents" + File.separator + "Java" + File.separator + "fonts") : new File("fonts");
                logsDir = boolMacOS ? new File(userHomeDirectory + File.separator + "Documents" + File.separator + "ReconDownloadTool" + File.separator + "logs") : new File("logs");
                reportsDir = boolMacOS ? new File(userHomeDirectory + File.separator + "Documents" + File.separator + "ReconDownloadTool" + File.separator + "reports") : new File("reports");
                imagesDir = boolMacOS ? new File(userHomeDirectory + File.separator + "Documents" + File.separator + "ReconDownloadTool" + File.separator + "images") : new File("images");
            } else if (boolWindows) {
                baseDir = boolWindows ? new File(new JFileChooser().getFileSystemView().getDefaultDirectory().toString() + File.separator + "ReconDownloadTool") : new File("ReconDownloadTool");
                configDir = boolWindows ? new File(new JFileChooser().getFileSystemView().getDefaultDirectory().toString() + File.separator + "ReconDownloadTool" + File.separator + "config") : new File("config");
                dataDir = boolWindows ? new File(new JFileChooser().getFileSystemView().getDefaultDirectory().toString() + File.separator + "ReconDownloadTool" + File.separator + "data") : new File("data");
                fontsDir = new File("fonts");
                logsDir = boolWindows ? new File(new JFileChooser().getFileSystemView().getDefaultDirectory().toString() + File.separator + "ReconDownloadTool" + File.separator + "logs") : new File("logs");
                reportsDir = boolWindows ? new File(new JFileChooser().getFileSystemView().getDefaultDirectory().toString() + File.separator + "ReconDownloadTool" + File.separator + "reports") : new File("reports");
                imagesDir = boolWindows ? new File(new JFileChooser().getFileSystemView().getDefaultDirectory().toString() + File.separator + "ReconDownloadTool" + File.separator + "images") : new File("images");
            } else {
                baseDir = new File(userHomeDirectory + File.separator + ".ReconDownloadTool");
                configDir = new File(baseDir + File.separator + "config");
                dataDir = new File(baseDir + File.separator + "data");
                reportsDir = new File(baseDir + File.separator + "reports");
                fontsDir = new File("fonts");
                logsDir = new File(baseDir + File.separator + "logs");
                imagesDir = new File(baseDir + File.separator + "images");
            }
        }
        catch (Exception ex) {
            Logging.main("ERROR: assignWorkingDirectories!");
        }
    }
}

