/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.AppUI;
import MainMenu.InitDirs;
import MainMenu.LegacyUI;
import MainMenu.LoadSavedFile;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import MainMenu.TiltSensitivity;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CrosshairLabelGenerator;
import org.jfree.chart.labels.StandardCrosshairLabelGenerator;
import org.jfree.chart.panel.CrosshairOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.general.DatasetUtils;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class CreateGraph
extends JFrame {
    private static int indexYear = 3;
    private static int indexMonth = 4;
    private static int indexDay = 5;
    private static int indexHour = 6;
    private static int indexMinute = 7;
    private static int indexSecond = 8;
    private static boolean drawingRadon;
    public static double OverallAvgRnC;
    public static boolean photodiodeFailure_Ch1;
    public static boolean photodiodeFailure_Ch2;
    public static ArrayList<ArrayList<String>> HourlyReconData;
    private static int recordHourMinutes;

    public CreateGraph(String title) {
        super(title);
        this.setContentPane(CreateGraph.createPanel());
    }

    public static JPanel createPanel() {
        return new MyPanel();
    }

    public static void main(String[] args) {
        if (MainMenuUI.appUI instanceof MainMenuUI) {
            AppUI.pnlGraph.removeAll();
            AppUI.pnlGraph.add(CreateGraph.createPanel());
            AppUI.pnlGraph.revalidate();
            AppUI.pnlGraph.repaint();
        } else if (MainMenuUI.appUI instanceof LegacyUI) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateGraph app = new CreateGraph(LoadSavedFile.strOpenFileName);
                    app.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            MainMenuUI.appUI.CloseFile();
                            LegacyUI.ClearDeploymentFields();
                        }
                    });
                    app.pack();
                    app.setVisible(true);
                }
            });
        }
    }

    public static void SaveGraph(JFreeChart chart) {
        try {
            ChartUtils.saveChartAsPNG((File)new File(InitDirs.baseDir + File.separator + "graph.png"), (JFreeChart)chart, (int)AppUI.intChartImageWidth, (int)AppUI.intChartImageHeight);
        }
        catch (Exception ex) {
            Logging.main("ERROR: Cannot externalize graph to PNG image.");
        }
    }

    private static boolean isDataRecord(String input) {
        if (input.equals("S")) {
            return true;
        }
        if (input.equals("I")) {
            return true;
        }
        if (input.equals("E")) {
            return true;
        }
        if (input.equals("1")) {
            return true;
        }
        if (input.equals("0")) {
            return true;
        }
        return input.equals("2");
    }

    private static boolean isStartRecord(String input) {
        if (input.equals("S")) {
            return true;
        }
        return input.equals("1");
    }

    static {
        OverallAvgRnC = 0.0;
        photodiodeFailure_Ch1 = false;
        photodiodeFailure_Ch2 = false;
        HourlyReconData = new ArrayList();
    }

    static class MyPanel
    extends JPanel
    implements ChartMouseListener {
        private static int SERIES_COUNT = 1;
        private ChartPanel chartPanel;
        private Crosshair xCrosshair;
        private Crosshair[] yCrosshairs;

        public MyPanel() {
            super(new BorderLayout());
            switch (LoadSavedFile.dataType) {
                case RECON: {
                    indexYear = 3;
                    indexMonth = 4;
                    indexDay = 5;
                    indexHour = 6;
                    indexMinute = 7;
                    indexSecond = 8;
                    drawingRadon = true;
                    SERIES_COUNT = 1;
                    if (AppUI.boolUseTwoChambers) {
                        SERIES_COUNT += 2;
                    }
                    recordHourMinutes = 60;
                    break;
                }
                case ANYTM: {
                    indexYear = 4;
                    indexMonth = 5;
                    indexDay = 6;
                    indexHour = 7;
                    indexMinute = 8;
                    indexSecond = 9;
                    drawingRadon = false;
                    recordHourMinutes = 55;
                    break;
                }
                default: {
                    recordHourMinutes = 60;
                }
            }
            JFreeChart chart = this.createChart(this.createDataset());
            CreateGraph.SaveGraph(chart);
            this.chartPanel = new ChartPanel(chart);
            this.chartPanel.addChartMouseListener((ChartMouseListener)this);
            CrosshairOverlay crosshairOverlay = new CrosshairOverlay();
            this.xCrosshair = new Crosshair(Double.NaN, (Paint)Color.GRAY, (Stroke)new BasicStroke(0.0f));
            this.xCrosshair.setLabelVisible(true);
            crosshairOverlay.addDomainCrosshair(this.xCrosshair);
            this.yCrosshairs = new Crosshair[SERIES_COUNT + 1];
            for (int i = 0; i < SERIES_COUNT; ++i) {
                this.yCrosshairs[i] = new Crosshair(Double.NaN, (Paint)Color.GRAY, (Stroke)new BasicStroke(0.0f));
                this.yCrosshairs[i].setLabelVisible(true);
                if (i % 2 != 0) {
                    this.yCrosshairs[i].setLabelAnchor(RectangleAnchor.TOP_RIGHT);
                }
                crosshairOverlay.addRangeCrosshair(this.yCrosshairs[i]);
            }
            this.yCrosshairs[MyPanel.SERIES_COUNT] = new Crosshair(Double.NaN, (Paint)Color.GRAY, (Stroke)new BasicStroke(0.0f));
            this.yCrosshairs[SERIES_COUNT].setLabelVisible(true);
            if (SERIES_COUNT % 2 != 0) {
                this.yCrosshairs[SERIES_COUNT].setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            }
            crosshairOverlay.addRangeCrosshair(this.yCrosshairs[SERIES_COUNT]);
            Logging.main("RANGE CROSSHAIRS: " + Arrays.toString(crosshairOverlay.getRangeCrosshairs().toArray()));
            this.chartPanel.addOverlay((Overlay)crosshairOverlay);
            this.add((Component)this.chartPanel);
        }

        private JFreeChart createChart(XYDataset[] dataset) {
            XYPlot plot;
            block76: {
                NumberFormat formatterHumidity;
                block75: {
                    NumberFormat formatterTemp;
                    block74: {
                        block73: {
                            block72: {
                                plot = new XYPlot();
                                plot.setDataset(0, dataset[0]);
                                plot.setDataset(1, dataset[1]);
                                plot.setDataset(2, dataset[2]);
                                plot.setDataset(3, dataset[3]);
                                plot.setDataset(4, dataset[4]);
                                XYSplineRenderer spline_radon = new XYSplineRenderer();
                                XYSplineRenderer spline_humidity = new XYSplineRenderer();
                                XYSplineRenderer spline_temp = new XYSplineRenderer();
                                XYSplineRenderer spline_press = new XYSplineRenderer();
                                XYBarRenderer bar_movement = new XYBarRenderer();
                                plot.setRenderer(0, (XYItemRenderer)spline_radon);
                                plot.setRenderer(1, (XYItemRenderer)spline_humidity);
                                plot.setRenderer(2, (XYItemRenderer)spline_temp);
                                plot.setRenderer(3, (XYItemRenderer)spline_press);
                                plot.setRenderer(4, (XYItemRenderer)bar_movement);
                                if (!drawingRadon) {
                                    spline_radon.setDefaultSeriesVisible(false);
                                    spline_radon.setSeriesLinesVisible(0, false);
                                }
                                spline_radon.setDefaultShapesVisible(false);
                                spline_humidity.setDefaultShapesVisible(false);
                                spline_temp.setDefaultShapesVisible(false);
                                spline_press.setDefaultShapesVisible(false);
                                bar_movement.setShadowVisible(false);
                                bar_movement.setDrawBarOutline(false);
                                bar_movement.setBarPainter((XYBarPainter)new StandardXYBarPainter());
                                Logging.main("Setting default strokes (line thicknesses) of chart renderers...");
                                try {
                                    if (AppUI.boolUseTwoChambers) {
                                        spline_radon.setAutoPopulateSeriesStroke(false);
                                        spline_radon.setSeriesStroke(0, (Stroke)new BasicStroke(AppUI.fltChartStrokeRadon1));
                                        spline_radon.setSeriesStroke(1, (Stroke)new BasicStroke(AppUI.fltChartStrokeRadon2));
                                        spline_radon.setSeriesStroke(2, (Stroke)new BasicStroke(AppUI.fltChartStrokeRadonAvg));
                                    } else {
                                        spline_radon.setDefaultStroke((Stroke)new BasicStroke(AppUI.fltChartStrokeRadonAvg));
                                        spline_radon.setAutoPopulateSeriesStroke(false);
                                    }
                                }
                                catch (Exception anyEx) {
                                    Logging.main("Unable to parse stroke for radon series. Using auto value...");
                                    spline_radon.setAutoPopulateSeriesStroke(true);
                                }
                                try {
                                    spline_humidity.setDefaultStroke((Stroke)new BasicStroke(AppUI.fltChartStrokeHumidity));
                                    spline_humidity.setAutoPopulateSeriesStroke(false);
                                }
                                catch (Exception anyEx) {
                                    Logging.main("Unable to parse stroke for humidity series. Using auto value...");
                                    spline_humidity.setAutoPopulateSeriesStroke(true);
                                }
                                try {
                                    spline_temp.setDefaultStroke((Stroke)new BasicStroke(AppUI.fltChartStrokeTemperature));
                                    spline_temp.setAutoPopulateSeriesStroke(false);
                                }
                                catch (Exception anyEx) {
                                    Logging.main("Unable to parse stroke for temperature series. Using auto value...");
                                    spline_temp.setAutoPopulateSeriesStroke(true);
                                }
                                try {
                                    spline_press.setDefaultStroke((Stroke)new BasicStroke(AppUI.fltChartStrokePressure));
                                    spline_press.setAutoPopulateSeriesStroke(false);
                                }
                                catch (Exception anyEx) {
                                    Logging.main("Unable to parse stroke for pressure series. Using auto value...");
                                    spline_press.setAutoPopulateSeriesStroke(true);
                                }
                                try {
                                    bar_movement.setDefaultStroke((Stroke)new BasicStroke(AppUI.fltChartStrokeTilts));
                                    bar_movement.setAutoPopulateSeriesStroke(false);
                                }
                                catch (Exception anyEx) {
                                    Logging.main("Unable to parse bar thickness for tilts series. Using auto value...");
                                    bar_movement.setAutoPopulateSeriesStroke(true);
                                }
                                if (AppUI.boolUseTwoChambers) {
                                    plot.getRendererForDataset(plot.getDataset(0)).setSeriesPaint(0, (Paint)Color.decode(AppUI.strChartColorRadon1));
                                    plot.getRendererForDataset(plot.getDataset(0)).setSeriesPaint(1, (Paint)Color.decode(AppUI.strChartColorRadon2));
                                    if (!photodiodeFailure_Ch1 && !photodiodeFailure_Ch2) {
                                        plot.getRendererForDataset(plot.getDataset(0)).setSeriesPaint(2, (Paint)Color.decode(AppUI.strChartColorRadonAvg));
                                    }
                                } else {
                                    plot.getRendererForDataset(plot.getDataset(0)).setSeriesPaint(0, (Paint)Color.decode(AppUI.strChartColorRadonAvg));
                                }
                                plot.getRendererForDataset(plot.getDataset(1)).setSeriesPaint(0, (Paint)Color.decode(AppUI.strChartColorHumidity));
                                plot.getRendererForDataset(plot.getDataset(2)).setSeriesPaint(0, (Paint)Color.decode(AppUI.strChartColorTemperature));
                                plot.getRendererForDataset(plot.getDataset(3)).setSeriesPaint(0, (Paint)Color.decode(AppUI.strChartColorPressure));
                                plot.getRendererForDataset(plot.getDataset(4)).setSeriesPaint(0, (Paint)Color.decode(AppUI.strChartColorTilts));
                                if (LoadSavedFile.strUnitSystem.equals("SI")) {
                                    plot.setRangeAxis(0, (ValueAxis)new NumberAxis("Bq/m\u00b3"));
                                    plot.setRangeAxis(2, (ValueAxis)new NumberAxis("Temperature (\u00b0C)"));
                                    plot.setRangeAxis(3, (ValueAxis)new NumberAxis("Pressure (mbar)"));
                                } else {
                                    plot.setRangeAxis(0, (ValueAxis)new NumberAxis("pCi/L"));
                                    plot.setRangeAxis(2, (ValueAxis)new NumberAxis("Temperature (\u00b0F)"));
                                    plot.setRangeAxis(3, (ValueAxis)new NumberAxis("Pressure (inHg)"));
                                }
                                plot.setRangeAxis(1, (ValueAxis)new NumberAxis("%Humidity"));
                                plot.setRangeAxis(4, (ValueAxis)new NumberAxis("Tilt"));
                                plot.setDomainAxis((ValueAxis)new NumberAxis("Elapsed Time (Hours)"));
                                plot.getDomainAxis().setLabelPaint((Paint)Color.decode(AppUI.strChartColorXAxisLabels));
                                plot.getDomainAxis().setTickLabelPaint((Paint)Color.decode(AppUI.strChartColorXAxisLabels));
                                NumberAxis rangeRadon = (NumberAxis)plot.getRangeAxis(0);
                                if (!drawingRadon) {
                                    rangeRadon.setVisible(false);
                                }
                                NumberFormat formatterRadon = DecimalFormat.getInstance();
                                rangeRadon.setNumberFormatOverride(formatterRadon);
                                if (AppUI.strChartRangeRadon.equals("auto")) {
                                    rangeRadon.setRange(rangeRadon.getRange(), false, false);
                                } else {
                                    try {
                                        String[] arrChartRangeRadon = AppUI.strChartRangeRadon.split(" ");
                                        int intMinRangeRadon = Integer.parseInt(arrChartRangeRadon[0]);
                                        int intMaxRangeRadon = Integer.parseInt(arrChartRangeRadon[1]);
                                        rangeRadon.setRange((double)intMinRangeRadon, (double)intMaxRangeRadon);
                                    }
                                    catch (Exception anyEx) {
                                        Logging.main("Unable to parse custom y-axis range for radon series. Using autogenerated range...");
                                        rangeRadon.setRange(rangeRadon.getRange(), false, false);
                                    }
                                }
                                try {
                                    String[] arrChartFractionDigitsRadon = LoadSavedFile.strUnitSystem.equals("SI") ? AppUI.strChartFractionDigitsRadonSI.split(" ") : AppUI.strChartFractionDigitsRadonUS.split(" ");
                                    int intMinFractionDigitsRadon = Integer.parseInt(arrChartFractionDigitsRadon[0]);
                                    int intMaxFractionDigitsRadon = Integer.parseInt(arrChartFractionDigitsRadon[1]);
                                    formatterRadon.setMinimumFractionDigits(intMinFractionDigitsRadon);
                                    formatterRadon.setMaximumFractionDigits(intMaxFractionDigitsRadon);
                                }
                                catch (Exception anyEx) {
                                    String unitSystem = LoadSavedFile.strUnitSystem.equals("SI") ? "SI units" : "US units";
                                    Logging.main("Unable to parse custom y-axis fraction digits for radon series (" + unitSystem + "). Using default values...");
                                    formatterRadon.setMinimumFractionDigits(0);
                                    formatterRadon.setMaximumFractionDigits(0);
                                }
                                try {
                                    double dblChartTickUnitRadon = Double.parseDouble(AppUI.strChartTickUnitRadon);
                                    rangeRadon.setTickUnit(new NumberTickUnit(dblChartTickUnitRadon));
                                }
                                catch (Exception anyEx) {
                                    if (AppUI.strChartTickUnitRadon.equals("auto")) break block72;
                                    Logging.main("Unable to parse custom y-axis tick units for radon series. Using auto values...");
                                }
                            }
                            NumberAxis rangeHumidity = (NumberAxis)plot.getRangeAxis(1);
                            formatterHumidity = DecimalFormat.getInstance();
                            formatterHumidity.setMinimumFractionDigits(0);
                            formatterHumidity.setMaximumFractionDigits(0);
                            rangeHumidity.setNumberFormatOverride(formatterHumidity);
                            if (AppUI.strChartRangeHumidity.equals("auto")) {
                                rangeHumidity.setRange(rangeHumidity.getRange(), false, false);
                            } else {
                                try {
                                    String[] arrChartRangeHumidity = AppUI.strChartRangeHumidity.split(" ");
                                    int intMinRangeHumidity = Integer.parseInt(arrChartRangeHumidity[0]);
                                    int intMaxRangeHumidity = Integer.parseInt(arrChartRangeHumidity[1]);
                                    rangeHumidity.setRange((double)intMinRangeHumidity, (double)intMaxRangeHumidity);
                                }
                                catch (Exception anyEx) {
                                    Logging.main("Unable to parse custom y-axis range for humidity series. Using autogenerated range...");
                                    rangeHumidity.setRange(rangeHumidity.getRange(), false, false);
                                }
                            }
                            try {
                                String[] arrChartFractionDigitsHumidity = AppUI.strChartFractionDigitsHumidity.split(" ");
                                int intMinFractionDigitsHumidity = Integer.parseInt(arrChartFractionDigitsHumidity[0]);
                                int intMaxFractionDigitsHumidity = Integer.parseInt(arrChartFractionDigitsHumidity[1]);
                                formatterHumidity.setMinimumFractionDigits(intMinFractionDigitsHumidity);
                                formatterHumidity.setMaximumFractionDigits(intMaxFractionDigitsHumidity);
                            }
                            catch (Exception anyEx) {
                                Logging.main("Unable to parse custom y-axis fraction digits for humidity series. Using default values...");
                                formatterHumidity.setMinimumFractionDigits(0);
                                formatterHumidity.setMaximumFractionDigits(0);
                            }
                            try {
                                double dblChartTickUnitHumidity = Double.parseDouble(AppUI.strChartTickUnitHumidity);
                                rangeHumidity.setTickUnit(new NumberTickUnit(dblChartTickUnitHumidity));
                            }
                            catch (Exception anyEx) {
                                if (AppUI.strChartTickUnitHumidity.equals("auto")) break block73;
                                Logging.main("Unable to parse custom y-axis tick units for humidity series. Using auto values...");
                            }
                        }
                        NumberAxis rangeTemp = (NumberAxis)plot.getRangeAxis(2);
                        formatterTemp = DecimalFormat.getInstance();
                        rangeTemp.setNumberFormatOverride(formatterTemp);
                        if (LoadSavedFile.strUnitSystem.equals("SI")) {
                            if (AppUI.strChartRangeTemperatureSI.equals("auto")) {
                                rangeTemp.setRange(rangeTemp.getRange(), false, false);
                            } else {
                                try {
                                    String[] arrChartRangeTemperatureSI = AppUI.strChartRangeTemperatureSI.split(" ");
                                    int intMinRangeTemperature = Integer.parseInt(arrChartRangeTemperatureSI[0]);
                                    int intMaxRangeTemperature = Integer.parseInt(arrChartRangeTemperatureSI[1]);
                                    rangeTemp.setRange((double)intMinRangeTemperature, (double)intMaxRangeTemperature);
                                }
                                catch (Exception anyEx) {
                                    Logging.main("Unable to parse custom y-axis range for temperature series (SI units). Using autogenerated range...");
                                    rangeTemp.setRange(rangeTemp.getRange(), false, false);
                                }
                            }
                        } else if (AppUI.strChartRangeTemperatureUS.equals("auto")) {
                            rangeTemp.setRange(rangeTemp.getRange(), false, false);
                        } else {
                            try {
                                String[] arrChartRangeTemperatureUS = AppUI.strChartRangeTemperatureUS.split(" ");
                                int intMinRangeTemperature = Integer.parseInt(arrChartRangeTemperatureUS[0]);
                                int intMaxRangeTemperature = Integer.parseInt(arrChartRangeTemperatureUS[1]);
                                rangeTemp.setRange((double)intMinRangeTemperature, (double)intMaxRangeTemperature);
                            }
                            catch (Exception anyEx) {
                                Logging.main("Unable to parse custom y-axis range for temperature series (US units). Using autogenerated range...");
                                rangeTemp.setRange(rangeTemp.getRange(), false, false);
                            }
                        }
                        try {
                            String[] arrChartFractionDigitsTemperature = LoadSavedFile.strUnitSystem.equals("SI") ? AppUI.strChartFractionDigitsTemperatureSI.split(" ") : AppUI.strChartFractionDigitsTemperatureUS.split(" ");
                            int intMinFractionDigitsTemperature = Integer.parseInt(arrChartFractionDigitsTemperature[0]);
                            int intMaxFractionDigitsTemperature = Integer.parseInt(arrChartFractionDigitsTemperature[1]);
                            formatterTemp.setMinimumFractionDigits(intMinFractionDigitsTemperature);
                            formatterTemp.setMaximumFractionDigits(intMaxFractionDigitsTemperature);
                        }
                        catch (Exception anyEx) {
                            String unitSystem = LoadSavedFile.strUnitSystem.equals("SI") ? "SI units" : "US units";
                            Logging.main("Unable to parse custom y-axis fraction digits for temperature series (" + unitSystem + "). Using default values...");
                            formatterTemp.setMinimumFractionDigits(0);
                            formatterTemp.setMaximumFractionDigits(0);
                        }
                        try {
                            double dblChartTickUnitTemperature = Double.parseDouble(LoadSavedFile.strUnitSystem.equals("SI") ? AppUI.strChartTickUnitTemperatureSI : AppUI.strChartTickUnitTemperatureUS);
                            rangeTemp.setTickUnit(new NumberTickUnit(dblChartTickUnitTemperature));
                        }
                        catch (Exception anyEx) {
                            if ((LoadSavedFile.strUnitSystem.equals("SI") ? AppUI.strChartTickUnitPressureSI : AppUI.strChartTickUnitPressureUS).equals("auto")) break block74;
                            Logging.main("Unable to parse custom y-axis tick units for temperature series. Using auto values...");
                        }
                    }
                    NumberAxis rangePressure = (NumberAxis)plot.getRangeAxis(3);
                    NumberFormat formatterPressure = DecimalFormat.getInstance();
                    rangePressure.setNumberFormatOverride(formatterPressure);
                    if (LoadSavedFile.strUnitSystem.equals("SI")) {
                        if (AppUI.strChartRangePressureSI.equals("auto")) {
                            rangePressure.setRange(rangePressure.getRange(), false, false);
                        } else {
                            try {
                                String[] arrChartRangePressureSI = AppUI.strChartRangePressureSI.split(" ");
                                int intMinRangePressure = Integer.parseInt(arrChartRangePressureSI[0]);
                                int intMaxRangePressure = Integer.parseInt(arrChartRangePressureSI[1]);
                                rangePressure.setRange((double)intMinRangePressure, (double)intMaxRangePressure);
                            }
                            catch (Exception anyEx) {
                                Logging.main("Unable to parse custom y-axis range for pressure series (SI units). Using autogenerated range...");
                                rangePressure.setRange(rangePressure.getRange(), false, false);
                            }
                        }
                    } else if (AppUI.strChartRangePressureUS.equals("auto")) {
                        rangePressure.setRange(rangePressure.getRange(), false, false);
                    } else {
                        try {
                            String[] arrChartRangePressureUS = AppUI.strChartRangePressureUS.split(" ");
                            int intMinRangePressure = Integer.parseInt(arrChartRangePressureUS[0]);
                            int intMaxRangePressure = Integer.parseInt(arrChartRangePressureUS[1]);
                            rangePressure.setRange((double)intMinRangePressure, (double)intMaxRangePressure);
                        }
                        catch (Exception anyEx) {
                            Logging.main("Unable to parse custom y-axis range for pressure series (US units). Using autogenerated range...");
                            rangePressure.setRange(rangePressure.getRange(), false, false);
                        }
                    }
                    try {
                        String[] arrChartFractionDigitsPressure = LoadSavedFile.strUnitSystem.equals("SI") ? AppUI.strChartFractionDigitsPressureSI.split(" ") : AppUI.strChartFractionDigitsPressureUS.split(" ");
                        int intMinFractionDigitsPressure = Integer.parseInt(arrChartFractionDigitsPressure[0]);
                        int intMaxFractionDigitsPressure = Integer.parseInt(arrChartFractionDigitsPressure[1]);
                        formatterPressure.setMinimumFractionDigits(intMinFractionDigitsPressure);
                        formatterPressure.setMaximumFractionDigits(intMaxFractionDigitsPressure);
                    }
                    catch (Exception anyEx) {
                        String unitSystem = LoadSavedFile.strUnitSystem.equals("SI") ? "SI units" : "US units";
                        Logging.main("Unable to parse custom y-axis fraction digits for pressure series (" + unitSystem + "). Using default values...");
                        formatterTemp.setMinimumFractionDigits(LoadSavedFile.strUnitSystem.equals("SI") ? 0 : 1);
                        formatterTemp.setMaximumFractionDigits(LoadSavedFile.strUnitSystem.equals("SI") ? 0 : 1);
                    }
                    try {
                        double dblChartTickUnitPressure = Double.parseDouble(LoadSavedFile.strUnitSystem.equals("SI") ? AppUI.strChartTickUnitPressureSI : AppUI.strChartTickUnitPressureUS);
                        rangePressure.setTickUnit(new NumberTickUnit(dblChartTickUnitPressure));
                    }
                    catch (Exception anyEx) {
                        if ((LoadSavedFile.strUnitSystem.equals("SI") ? AppUI.strChartTickUnitPressureSI : AppUI.strChartTickUnitPressureUS).equals("auto")) break block75;
                        Logging.main("Unable to parse custom y-axis tick units for pressure series. Using auto values...");
                    }
                }
                NumberAxis rangeMovement = (NumberAxis)plot.getRangeAxis(4);
                NumberFormat formatterMovement = DecimalFormat.getInstance();
                rangeMovement.setNumberFormatOverride(formatterMovement);
                if (AppUI.strChartRangeTilts.equals("auto")) {
                    rangeMovement.setRange(rangeMovement.getRange(), false, false);
                } else {
                    try {
                        String[] arrChartRangeTilts = AppUI.strChartRangeTilts.split(" ");
                        int intMinRangeTilts = Integer.parseInt(arrChartRangeTilts[0]);
                        int intMaxRangeTilts = Integer.parseInt(arrChartRangeTilts[1]);
                        rangeMovement.setRange((double)intMinRangeTilts, (double)intMaxRangeTilts);
                    }
                    catch (Exception anyEx) {
                        Logging.main("Unable to parse custom y-axis range for tilts series. Using autogenerated range...");
                        rangeMovement.setRange(rangeMovement.getRange(), false, false);
                    }
                }
                try {
                    String[] arrChartFractionDigitsTilts = AppUI.strChartFractionDigitsTilts.split(" ");
                    int intMinFractionDigitsTilts = Integer.parseInt(arrChartFractionDigitsTilts[0]);
                    int intMaxFractionDigitsTilts = Integer.parseInt(arrChartFractionDigitsTilts[1]);
                    formatterMovement.setMinimumFractionDigits(intMinFractionDigitsTilts);
                    formatterMovement.setMaximumFractionDigits(intMaxFractionDigitsTilts);
                }
                catch (Exception anyEx) {
                    Logging.main("Unable to parse custom y-axis fraction digits for tilts series. Using default values...");
                    formatterHumidity.setMinimumFractionDigits(0);
                    formatterHumidity.setMaximumFractionDigits(0);
                }
                try {
                    double dblChartTickUnitTilts = Double.parseDouble(AppUI.strChartTickUnitTilts);
                    rangeMovement.setTickUnit(new NumberTickUnit(dblChartTickUnitTilts));
                }
                catch (Exception anyEx) {
                    if (AppUI.strChartTickUnitTilts.equals("auto")) break block76;
                    Logging.main("Unable to parse custom y-axis tick units for tilts series. Using auto values...");
                }
            }
            plot.mapDatasetToRangeAxis(0, 0);
            plot.mapDatasetToRangeAxis(1, 1);
            plot.mapDatasetToRangeAxis(2, 2);
            plot.mapDatasetToRangeAxis(3, 3);
            plot.mapDatasetToRangeAxis(4, 4);
            plot.getRangeAxis(0).setLabelPaint((Paint)Color.decode(AppUI.strChartColorRadonAvg));
            plot.getRangeAxis(1).setLabelPaint((Paint)Color.decode(AppUI.strChartColorHumidity));
            plot.getRangeAxis(2).setLabelPaint((Paint)Color.decode(AppUI.strChartColorTemperature));
            plot.getRangeAxis(3).setLabelPaint((Paint)Color.decode(AppUI.strChartColorPressure));
            plot.getRangeAxis(4).setLabelPaint((Paint)Color.decode(AppUI.strChartColorTilts));
            plot.getRangeAxis(0).setAxisLinePaint((Paint)Color.decode(AppUI.strChartColorRadonAvg));
            plot.getRangeAxis(1).setAxisLinePaint((Paint)Color.decode(AppUI.strChartColorHumidity));
            plot.getRangeAxis(2).setAxisLinePaint((Paint)Color.decode(AppUI.strChartColorTemperature));
            plot.getRangeAxis(3).setAxisLinePaint((Paint)Color.decode(AppUI.strChartColorPressure));
            plot.getRangeAxis(4).setAxisLinePaint((Paint)Color.decode(AppUI.strChartColorTilts));
            plot.getRangeAxis(0).setTickLabelPaint((Paint)Color.decode(AppUI.strChartColorRadonAvg));
            plot.getRangeAxis(1).setTickLabelPaint((Paint)Color.decode(AppUI.strChartColorHumidity));
            plot.getRangeAxis(2).setTickLabelPaint((Paint)Color.decode(AppUI.strChartColorTemperature));
            plot.getRangeAxis(3).setTickLabelPaint((Paint)Color.decode(AppUI.strChartColorPressure));
            plot.getRangeAxis(4).setTickLabelPaint((Paint)Color.decode(AppUI.strChartColorTilts));
            JFreeChart chart = new JFreeChart("Radon Concentration", this.getFont(), (Plot)plot, true);
            plot.setBackgroundPaint((Paint)Color.decode(AppUI.strChartColorBackground));
            chart.setBackgroundPaint((Paint)Color.decode(AppUI.strChartColorBackground));
            chart.getLegend().setBackgroundPaint((Paint)Color.decode(AppUI.strChartColorLegendBackground));
            chart.getLegend().setItemPaint((Paint)Color.decode(AppUI.strChartColorLegendLabels));
            if (drawingRadon && AppUI.excludeFirst4Hours) {
                IntervalMarker ExcludedGraphShade = new IntervalMarker(0.0, 4.0);
                ExcludedGraphShade.setAlpha(0.3f);
                plot.addDomainMarker((Marker)ExcludedGraphShade, Layer.FOREGROUND);
            }
            return chart;
        }

        private XYDataset[] createDataset() {
            XYSeriesCollection datasetRadon = new XYSeriesCollection();
            XYSeriesCollection datasetHumidity = new XYSeriesCollection();
            XYSeriesCollection datasetTemp = new XYSeriesCollection();
            XYSeriesCollection datasetPress = new XYSeriesCollection();
            XYSeriesCollection datasetMovement = new XYSeriesCollection();
            XYSeriesCollection[] datasetArray = new XYSeriesCollection[]{new XYSeriesCollection(), new XYSeriesCollection(), new XYSeriesCollection(), new XYSeriesCollection(), new XYSeriesCollection()};
            DateTimeFormatter DateTimeDisplay = DateTimeFormatter.ofPattern("MM-dd-yyyy HH:mm");
            LocalDateTime ReconDate = null;
            LocalDateTime HourCounter = null;
            DecimalFormat formatUS_RnC = new DecimalFormat("#0.0");
            DecimalFormat formatSI_RnC = new DecimalFormat("#0");
            DecimalFormat formatZero = new DecimalFormat("#0");
            DecimalFormat formatTenth = new DecimalFormat("#0.0");
            long Ch1Counts = 0L;
            long Ch2Counts = 0L;
            double hourlyAvgHumidity = 0.0;
            double hourlyAvgTemp = 0.0;
            double hourlyAvgPress = 0.0;
            double TotalAvgRnC = 0.0;
            double TotalAvgRnC_Ch1 = 0.0;
            double TotalAvgRnC_Ch2 = 0.0;
            double TotalAvgRnC_Ch1_Raw = 0.0;
            double TotalAvgRnC_Ch2_Raw = 0.0;
            long TotalHourCounter = 0L;
            long hourlyMovement = 0L;
            int TempYear = 0;
            long diffMinutes = 0L;
            long tempCounts_Ch1 = 0L;
            long tempCounts_Ch2 = 0L;
            long hourCounter = 0L;
            int avgCounter = 0;
            int consecutiveZeroTally_Ch1 = 0;
            int consecutiveZeroTally_Ch2 = 0;
            long rawCh1Counts = 0L;
            long rawCh2Counts = 0L;
            long rawTempCounts_Ch1 = 0L;
            long rawTempCounts_Ch2 = 0L;
            boolean rawCountsExist = false;
            Logging.main("Attempting to construct graph from ArrayList of size " + LoadSavedFile.LoadedReconDataFile.size() + "...");
            XYSeries Ch1_Series = new XYSeries((Comparable)((Object)"Ch1_RnC"));
            XYSeries Ch2_Series = new XYSeries((Comparable)((Object)"Ch2_RnC"));
            XYSeries AvgRnC_Series = new XYSeries((Comparable)((Object)"Avg. Radon Concentration"));
            XYSeries AvgHumidity_Series = new XYSeries((Comparable)((Object)"%Humidity"));
            XYSeries AvgTemp_Series = new XYSeries((Comparable)((Object)"Temperature"));
            XYSeries AvgPress_Series = new XYSeries((Comparable)((Object)"Pressure"));
            XYSeries Movement_Series = new XYSeries((Comparable)((Object)"Tilt"));
            XYSeries Ch1_Raw = new XYSeries((Comparable)((Object)"Ch1_RnC_Raw"));
            XYSeries Ch2_Raw = new XYSeries((Comparable)((Object)"Ch2_RnC_Raw"));
            if (LoadSavedFile.strUnitSystem.equals("SI")) {
                Logging.main("SI Units detected in Config for graph.");
            } else if (LoadSavedFile.strUnitSystem.equals("US")) {
                Logging.main("US Units detected in Config for graph.");
            } else {
                Logging.main("No units detected in Config for graph... defaulting to US.");
            }
            HourlyReconData.clear();
            ArrayList<String> arrLine = new ArrayList<String>();
            ArrayList arrLine_temp = new ArrayList();
            for (int arrayCounter = 0; arrayCounter < LoadSavedFile.LoadedReconDataFile.size(); ++arrayCounter) {
                if (!CreateGraph.isDataRecord(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(2))) continue;
                if (CreateGraph.isStartRecord(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(2))) {
                    TempYear = 2000 + Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexYear));
                    HourCounter = LocalDateTime.of(TempYear, Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexMonth)), Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexDay)), Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexHour)), Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexMinute)), 0);
                }
                if (drawingRadon) {
                    Ch1Counts = Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(10));
                    Ch2Counts = Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(11));
                }
                switch (LoadSavedFile.dataType) {
                    case RECON: {
                        hourlyAvgHumidity += Double.parseDouble(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(15));
                        hourlyAvgTemp += Double.parseDouble(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(21));
                        hourlyAvgPress += Double.parseDouble(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(18));
                        hourlyMovement += Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(9));
                        break;
                    }
                    case ANYTM: {
                        hourlyAvgHumidity += Double.parseDouble(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(18)) / 10.0;
                        hourlyAvgTemp += Double.parseDouble(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(12)) / 10.0;
                        hourlyAvgPress += Double.parseDouble(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(15)) / 10.0;
                        hourlyMovement += Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(10));
                        break;
                    }
                }
                ++avgCounter;
                if (drawingRadon) {
                    tempCounts_Ch1 += Ch1Counts;
                    tempCounts_Ch2 += Ch2Counts;
                    if (LoadSavedFile.LoadedReconDataFile.get(arrayCounter).size() >= 28) {
                        if (!rawCountsExist) {
                            rawCountsExist = true;
                        }
                        rawCh1Counts = LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(26).contains("false") ? Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(10)) : (LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(26).contains("true(") && LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(26).contains(")") ? Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(26).replaceAll("[^0-9]", "")) : Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(10)));
                        rawCh2Counts = LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(27).contains("false") ? Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(11)) : (LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(27).contains("true(") && LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(27).contains(")") ? Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(27).replaceAll("[^0-9]", "")) : Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(11)));
                    } else {
                        rawCh1Counts = Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(10));
                        rawCh2Counts = Long.parseLong(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(11));
                    }
                    rawTempCounts_Ch1 += rawCh1Counts;
                    rawTempCounts_Ch2 += rawCh2Counts;
                    if (Ch1Counts == 0L) {
                        consecutiveZeroTally_Ch1 = Ch2Counts < 5L ? (int)((double)consecutiveZeroTally_Ch1 + 0.1) : ++consecutiveZeroTally_Ch1;
                        if ((double)consecutiveZeroTally_Ch1 >= AppUI.ConsecutiveZeroLimit && !photodiodeFailure_Ch1) {
                            if (AppUI.photodiodeFailureRecovery) {
                                JOptionPane.showMessageDialog(null, "Potential photodiode failure has been detected in chamber 1. The software will attempt to construct the graph and report using chamber 2.", "Potential Failure in Chamber #1", 1);
                            } else {
                                JOptionPane.showMessageDialog(null, "Potential photodiode failure has been detected in chamber 1.", "Potential Failure in Chamber #1", 1);
                            }
                            Logging.main("WARNING: Possible photodiode failure detected in chamber 1 when creating graph.");
                            photodiodeFailure_Ch1 = true;
                        }
                    } else {
                        consecutiveZeroTally_Ch1 = 0;
                    }
                    if (Ch2Counts == 0L) {
                        consecutiveZeroTally_Ch2 = Ch1Counts < 5L ? (int)((double)consecutiveZeroTally_Ch2 + 0.1) : ++consecutiveZeroTally_Ch2;
                        if ((double)consecutiveZeroTally_Ch2 >= AppUI.ConsecutiveZeroLimit && !photodiodeFailure_Ch2) {
                            if (AppUI.photodiodeFailureRecovery) {
                                JOptionPane.showMessageDialog(null, "Potential photodiode failure has been detected in chamber 2. The software will attempt to construct the graph and report using chamber 1.", "Potential Failure in Chamber #2", 1);
                            } else {
                                JOptionPane.showMessageDialog(null, "Potential photodiode failure has been detected in chamber 2.", "Potential Failure in Chamber #2", 1);
                            }
                            Logging.main("WARNING: Possible photodiode failure detected in chamber 2 when creating graph.");
                            photodiodeFailure_Ch2 = true;
                        }
                    } else {
                        consecutiveZeroTally_Ch2 = 0;
                    }
                }
                TempYear = 2000 + Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexYear));
                ReconDate = LocalDateTime.of(TempYear, Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexMonth)), Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexDay)), Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexHour)), Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexMinute)), Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexSecond)));
                if (HourCounter == null || ReconDate == null || (diffMinutes = ChronoUnit.MINUTES.between(HourCounter, ReconDate)) < (long)recordHourMinutes) continue;
                TempYear = 2000 + Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexYear));
                HourCounter = LocalDateTime.of(TempYear, Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexMonth)), Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexDay)), Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexHour)), Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexMinute)), Integer.parseInt(LoadSavedFile.LoadedReconDataFile.get(arrayCounter).get(indexSecond)));
                AvgHumidity_Series.add((double)(++hourCounter), hourlyAvgHumidity / (double)avgCounter);
                switch (LoadSavedFile.dataType) {
                    case RECON: {
                        hourlyMovement = TiltSensitivity.main(hourlyMovement);
                        break;
                    }
                }
                Movement_Series.add((double)hourCounter, (double)hourlyMovement);
                if (LoadSavedFile.strUnitSystem.equals("SI")) {
                    Ch1_Series.add((double)hourCounter, (double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 * 37.0);
                    Ch2_Series.add((double)hourCounter, (double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2 * 37.0);
                    AvgRnC_Series.add((double)hourCounter, ((double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 + (double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2) / 2.0 * 37.0);
                    AvgTemp_Series.add((double)hourCounter, hourlyAvgTemp / (double)avgCounter);
                    AvgPress_Series.add((double)hourCounter, hourlyAvgPress / (double)avgCounter);
                    Ch1_Raw.add((double)hourCounter, (double)rawTempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 * 37.0);
                    Ch2_Raw.add((double)hourCounter, (double)rawTempCounts_Ch2 / LoadSavedFile.LoadedReconCF2 * 37.0);
                    if (TotalHourCounter > 3L && AppUI.excludeFirst4Hours || !AppUI.excludeFirst4Hours) {
                        TotalAvgRnC += ((double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 + (double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2) / 2.0 * 37.0;
                        TotalAvgRnC_Ch1 += (double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 * 37.0;
                        TotalAvgRnC_Ch2 += (double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2 * 37.0;
                        TotalAvgRnC_Ch1_Raw += (double)rawTempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 * 37.0;
                        TotalAvgRnC_Ch2_Raw += (double)rawTempCounts_Ch2 / LoadSavedFile.LoadedReconCF2 * 37.0;
                    }
                    arrLine.add(0, Long.toString(++TotalHourCounter));
                    arrLine.add(1, ReconDate.toString());
                    arrLine.add(2, formatSI_RnC.format(((double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 + (double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2) / 2.0 * 37.0));
                    arrLine.add(3, formatZero.format(hourlyAvgTemp / (double)avgCounter));
                    arrLine.add(4, formatTenth.format(hourlyAvgPress / (double)avgCounter));
                    arrLine.add(5, formatZero.format(hourlyAvgHumidity / (double)avgCounter));
                    arrLine.add(6, formatZero.format(Math.round(hourlyMovement)));
                    arrLine.add(7, formatUS_RnC.format((double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 * 37.0));
                    arrLine.add(8, formatUS_RnC.format((double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2 * 37.0));
                    arrLine.add(9, rawCountsExist ? formatSI_RnC.format((double)rawTempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 * 37.0) : formatSI_RnC.format((double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 * 37.0));
                    arrLine.add(10, rawCountsExist ? formatSI_RnC.format((double)rawTempCounts_Ch2 / LoadSavedFile.LoadedReconCF2 * 37.0) : formatSI_RnC.format((double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2 * 37.0));
                } else {
                    Ch1_Series.add((double)hourCounter, (double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1);
                    Ch2_Series.add((double)hourCounter, (double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2);
                    AvgRnC_Series.add((double)hourCounter, ((double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 + (double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2) / 2.0);
                    AvgTemp_Series.add((double)hourCounter, hourlyAvgTemp / (double)avgCounter * 9.0 / 5.0 + 32.0);
                    AvgPress_Series.add((double)hourCounter, hourlyAvgPress / (double)avgCounter * 0.02952998751);
                    Ch1_Raw.add((double)hourCounter, (double)rawTempCounts_Ch1 / LoadSavedFile.LoadedReconCF1);
                    Ch2_Raw.add((double)hourCounter, (double)rawTempCounts_Ch2 / LoadSavedFile.LoadedReconCF2);
                    if (TotalHourCounter > 3L && AppUI.excludeFirst4Hours || !AppUI.excludeFirst4Hours) {
                        TotalAvgRnC += ((double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 + (double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2) / 2.0;
                        TotalAvgRnC_Ch1 += (double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1;
                        TotalAvgRnC_Ch2 += (double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2;
                        TotalAvgRnC_Ch1_Raw += (double)rawTempCounts_Ch1 / LoadSavedFile.LoadedReconCF1;
                        TotalAvgRnC_Ch2_Raw += (double)rawTempCounts_Ch2 / LoadSavedFile.LoadedReconCF2;
                    }
                    arrLine.add(0, Long.toString(++TotalHourCounter));
                    arrLine.add(1, ReconDate.toString());
                    arrLine.add(2, formatUS_RnC.format(((double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1 + (double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2) / 2.0));
                    arrLine.add(3, formatZero.format(hourlyAvgTemp / (double)avgCounter * 9.0 / 5.0 + 32.0));
                    arrLine.add(4, formatTenth.format(hourlyAvgPress / (double)avgCounter * 0.02952998751));
                    arrLine.add(5, formatZero.format(hourlyAvgHumidity / (double)avgCounter));
                    arrLine.add(6, formatZero.format(Math.round(hourlyMovement)));
                    arrLine.add(7, formatUS_RnC.format((double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1));
                    arrLine.add(8, formatUS_RnC.format((double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2));
                    arrLine.add(9, rawCountsExist ? formatUS_RnC.format((double)rawTempCounts_Ch1 / LoadSavedFile.LoadedReconCF1) : formatUS_RnC.format((double)tempCounts_Ch1 / LoadSavedFile.LoadedReconCF1));
                    arrLine.add(10, rawCountsExist ? formatUS_RnC.format((double)rawTempCounts_Ch2 / LoadSavedFile.LoadedReconCF2) : formatUS_RnC.format((double)tempCounts_Ch2 / LoadSavedFile.LoadedReconCF2));
                    System.out.println(arrLine);
                }
                arrLine_temp = (ArrayList)arrLine.clone();
                HourlyReconData.add(arrLine_temp);
                arrLine.clear();
                tempCounts_Ch1 = 0L;
                tempCounts_Ch2 = 0L;
                rawTempCounts_Ch1 = 0L;
                rawTempCounts_Ch2 = 0L;
                hourlyAvgHumidity = 0.0;
                hourlyAvgTemp = 0.0;
                hourlyAvgPress = 0.0;
                hourlyMovement = 0L;
                avgCounter = 0;
            }
            OverallAvgRnC = AppUI.photodiodeFailureRecovery && photodiodeFailure_Ch1 && !photodiodeFailure_Ch2 ? (rawCountsExist ? TotalAvgRnC_Ch2_Raw : TotalAvgRnC_Ch2) / (double)(TotalHourCounter - (long)(AppUI.excludeFirst4Hours ? 4 : 0)) : (AppUI.photodiodeFailureRecovery && photodiodeFailure_Ch2 && !photodiodeFailure_Ch1 ? (rawCountsExist ? TotalAvgRnC_Ch1_Raw : TotalAvgRnC_Ch1) / (double)(TotalHourCounter - (long)(AppUI.excludeFirst4Hours ? 4 : 0)) : TotalAvgRnC / (double)(TotalHourCounter - (long)(AppUI.excludeFirst4Hours ? 4 : 0)));
            if (drawingRadon) {
                MainMenuUI.appUI.DisplayAvgRadonLabel(OverallAvgRnC);
            }
            if (AppUI.boolUseTwoChambers) {
                if (AppUI.photodiodeFailureRecovery && photodiodeFailure_Ch1 && !photodiodeFailure_Ch2) {
                    datasetRadon.addSeries(Ch1_Series);
                    datasetRadon.addSeries(rawCountsExist ? Ch2_Raw : Ch2_Series);
                    --SERIES_COUNT;
                } else if (AppUI.photodiodeFailureRecovery && photodiodeFailure_Ch2 && !photodiodeFailure_Ch1) {
                    datasetRadon.addSeries(rawCountsExist ? Ch1_Raw : Ch1_Series);
                    datasetRadon.addSeries(Ch2_Series);
                    --SERIES_COUNT;
                } else if (AppUI.photodiodeFailureRecovery && photodiodeFailure_Ch1 && photodiodeFailure_Ch2) {
                    datasetRadon.addSeries(rawCountsExist ? Ch1_Raw : Ch1_Series);
                    datasetRadon.addSeries(rawCountsExist ? Ch2_Raw : Ch2_Series);
                    datasetRadon.addSeries(AvgRnC_Series);
                } else {
                    datasetRadon.addSeries(Ch1_Series);
                    datasetRadon.addSeries(Ch2_Series);
                    datasetRadon.addSeries(AvgRnC_Series);
                }
            } else if (AppUI.photodiodeFailureRecovery && photodiodeFailure_Ch1 && !photodiodeFailure_Ch2) {
                datasetRadon.addSeries(rawCountsExist ? Ch2_Raw : Ch2_Series);
            } else if (AppUI.photodiodeFailureRecovery && photodiodeFailure_Ch2 && !photodiodeFailure_Ch1) {
                datasetRadon.addSeries(rawCountsExist ? Ch1_Raw : Ch1_Series);
            } else {
                datasetRadon.addSeries(AvgRnC_Series);
            }
            datasetHumidity.addSeries(AvgHumidity_Series);
            datasetTemp.addSeries(AvgTemp_Series);
            datasetPress.addSeries(AvgPress_Series);
            datasetMovement.addSeries(Movement_Series);
            datasetArray[0] = datasetRadon;
            datasetArray[1] = datasetHumidity;
            datasetArray[2] = datasetTemp;
            datasetArray[3] = datasetPress;
            datasetArray[4] = datasetMovement;
            return datasetArray;
        }

        public void chartMouseClicked(ChartMouseEvent event) {
        }

        public void chartMouseMoved(ChartMouseEvent event) {
            StandardCrosshairLabelGenerator yCrosshairLabel;
            Rectangle2D dataArea = this.chartPanel.getScreenDataArea();
            JFreeChart chart = event.getChart();
            XYPlot plot = (XYPlot)chart.getPlot();
            ValueAxis xAxis = plot.getDomainAxis();
            NumberFormat yCrossHairNumberFormat = NumberFormat.getInstance();
            yCrossHairNumberFormat.setMinimumIntegerDigits(1);
            if (LoadSavedFile.strUnitSystem.equals("SI")) {
                yCrossHairNumberFormat.setMinimumFractionDigits(0);
                yCrossHairNumberFormat.setMaximumFractionDigits(0);
                yCrosshairLabel = new StandardCrosshairLabelGenerator("{0} Bq/m\u00b3", yCrossHairNumberFormat);
            } else {
                yCrossHairNumberFormat.setMinimumFractionDigits(1);
                yCrossHairNumberFormat.setMaximumFractionDigits(1);
                yCrosshairLabel = new StandardCrosshairLabelGenerator("{0} pCi/L", yCrossHairNumberFormat);
            }
            NumberFormat humidityCrossHairNumberFormat = NumberFormat.getInstance();
            humidityCrossHairNumberFormat.setMinimumFractionDigits(0);
            humidityCrossHairNumberFormat.setMaximumFractionDigits(0);
            humidityCrossHairNumberFormat.setMinimumIntegerDigits(1);
            StandardCrosshairLabelGenerator humidityCrosshairLabel = new StandardCrosshairLabelGenerator("{0}%RH", humidityCrossHairNumberFormat);
            double x = xAxis.java2DToValue((double)event.getTrigger().getX(), dataArea, RectangleEdge.BOTTOM);
            this.xCrosshair.setValue(x);
            for (int i = 0; i < SERIES_COUNT; ++i) {
                double y = DatasetUtils.findYValue((XYDataset)plot.getDataset(0), (int)i, (double)x);
                this.yCrosshairs[i].setLabelGenerator((CrosshairLabelGenerator)yCrosshairLabel);
                this.yCrosshairs[i].setValue(y);
            }
        }
    }
}

